package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.NotificationApp;

import java.util.ArrayList;

public class NotificationAppDao {

    private final Db db;

    public NotificationAppDao(Db db) {
        this.db = db;
    }

    public ArrayList<NotificationApp> findAll() {

        ArrayList<NotificationApp> results = new ArrayList<>();
        String query = QueryGenerator.notificationApp();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {

                        results.add(ReaderContract.NotificationAppTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public void mergeAll(ArrayList<NotificationApp> apps) {
        try {

            ArrayList<String> values = new ArrayList<>();
            ArrayList<Integer> deletedIds = new ArrayList<>();

            for(NotificationApp app : apps) {
                if(app.getEnabled() == 0) {
                    deletedIds.add(app.getId());
                } else {
                    values.add(app.insertValues());

                }
            }
            String insertQuery = ReaderContract.NotificationAppTable.INSERT_QUERY + TextUtils.join(",", values);
            db.runQuery(insertQuery);

            db.delete(ReaderContract.NotificationAppTable.TABLE_NAME, ReaderContract.NotificationAppTable._ID + " IN (" + TextUtils.join(",", deletedIds) + ")", null);

        } catch (SQLiteException e) {
            e.printStackTrace();
        }

    }


}
