/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private VisualApi api;
    private ParserService parserService;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private boolean isDoingSignup;
    private boolean isDoingStartVisual;

    public VisualServiceImpl(@NonNull Context context, String apiKey, String qualifier, int appVersion) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is null");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier) || !"dev".equals(qualifier) && !"prod".equals(qualifier)) {
            throw new ParameterException("check qualifier value (dev, prod)");
        }
        this.context = context;
        AnswerManager.initFabric(context);
        this.repository = VisualRepository.getInstance(context);
        this.repository.saveSDKInfo(apiKey, qualifier, appVersion);
        this.api = VisualApi.getInstance(context);
        this.parserService = ParserService.getInstance((Context)context);
        this.alarmManager = VisualAlarmManager.getInstance(context);
        this.alarmManager.disableDailyAlarms();
    }

    @Override
    public void signUp(@NonNull String custId, final @NonNull OnResultListener onResultListener) throws ParameterException {
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        if (this.isDoingSignup) {
            return;
        }
        this.isDoingSignup = true;
        final SignUpRequest signUpRequest = new SignUpRequest(custId);
        Validator.notNull(onResultListener);
        if (!this.repository.shouldSignUp()) {
            onResultListener.onResult(2, "already joined");
            this.isDoingSignup = false;
            return;
        }
        AnswerManager.onKeyMetric(new LogRequest("signUp"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                signUpRequest.setAdId(Utils.getAdId(VisualServiceImpl.this.context));
                SignUpResponse response = VisualServiceImpl.this.api.signUp(signUpRequest);
                if (response == null || response.getResults() == null) {
                    onResultListener.onResult(1, "network error");
                } else {
                    VisualServiceImpl.this.repository.saveServerInfo(response);
                    onResultListener.onResult(0, "success");
                }
                VisualServiceImpl.this.isDoingSignup = false;
            }
        }).start();
    }

    @Override
    public void startVisual(@NonNull String custId, final @NonNull OnResultListener resultListener) throws ParameterException, SecurityException {
        LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
        if (this.isDoingStartVisual) {
            return;
        }
        this.isDoingStartVisual = true;
        Validator.notNull(resultListener);
        this.checkSMSPermission();
        this.signUp(custId, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                switch (signUpResult) {
                    case 0: 
                    case 2: {
                        try {
                            AnswerManager.onKeyMetric(new LogRequest("startVisual"));
                            VisualWebActivity.startActivity(VisualServiceImpl.this.context, "");
                            break;
                        }
                        catch (AuthException e) {
                            resultListener.onResult(1, e.toString());
                            return;
                        }
                        finally {
                            VisualServiceImpl.this.isDoingStartVisual = false;
                        }
                    }
                }
                resultListener.onResult(signUpResult, msg);
                VisualServiceImpl.this.isDoingStartVisual = false;
            }
        });
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.shouldShowTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    private void checkSMSPermission() throws SecurityException {
        if (!this.repository.isExecutedBulk() && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECEIVE_SMS") != 0) {
            throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS)");
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setActiveNoti("monthly", false);
            this.repository.setActiveNoti("weekly", false);
            this.repository.setActiveNoti("daily", false);
        }
        this.alarmManager.setAlarms();
    }

    @Override
    public void settingNotification(int smallIcon, @NonNull String channel, @NonNull String name, String description, int color2) throws ParameterException {
        Validator.notZero(smallIcon);
        Validator.notNull(channel);
        Validator.notNull(name);
        this.repository.settingNotification(smallIcon, channel, name, description, color2);
    }

    @Override
    public void setMonthlyNoti(boolean isActive) {
        this.repository.setActiveNoti("monthly", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveMonthlyNoti() {
        return this.repository.isActiveNoti("monthly");
    }

    @Override
    public void setWeeklyNoti(boolean isActive) {
        this.repository.setActiveNoti("weekly", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveWeeklyNoti() {
        return this.repository.isActiveNoti("weekly");
    }

    @Override
    public void setDailyNoti(boolean isActive) {
        this.repository.setActiveNoti("daily", isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveDailyNoti() {
        return this.repository.isActiveNoti("daily");
    }

    @Override
    public void setReportTest(String type, int second) {
        VisualAlarmManager.getInstance(this.context).setReportTest(type, second);
    }

    @Override
    public void setAuthority(String authority) {
        this.repository.saveAuthority(authority);
    }

    @Override
    public void setUserInfo(int birth, Constants.UserSex sex) {
        if (!this.repository.shouldSignUp() && !this.repository.isAlreadySaved()) {
            this.api.saveUserInfo(birth, sex);
        }
    }

    private boolean isActive() {
        return this.context != null;
    }
}

