package com.tenqube.visual_third;

import android.support.annotation.NonNull;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;

public interface VisualService {

    /**
     * 사용자 등록 프로세스
     * @param custId 사용자 고유정보값
     * @param onResultListener 등록 여부 결과 정보
     * @throws ParameterException custId 가 없는 경우 예외 발생
     */
    void signUp(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException;

    /**
     * 비주얼 가계부 화면 호출
     * 가입되지 않은 사용자 가입처리를 위해 파라미터 추가
     *
     * @param custId 사용자 고유정보값
     * @param onResultListener 미가입시 가입결과를 위한 콜백 함수
     * @throws ParameterException custId 가 없는 경우 예외 발생
     * @throws SecurityException 문자 권한이 없는경우 예외발생
     *
     */
    void startVisual(@NonNull String custId, @NonNull OnResultListener onResultListener) throws ParameterException, SecurityException;

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);
    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug 디버그 여부
     */
    void setDebugMode(boolean isDebug);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

    /**
     * 리포트를 위한 알림 설정정보 설정
     * @param smallIcon small 아이콘 res 정보
     * @param channel 사용중인 notification 채널정보
     * @param name 사용하고자 하는 알림 이름 default ""
     * @param description 알림 설명 default ""
     * @param color 알림 색상 default 0
     * @throws ParameterException 인자가없는 경우 발생
     */
    void settingNotification(int smallIcon, String channel, String name, String description, int color) throws ParameterException;

    /**
     * 월간 리포트 활성화 여부 저장
     * @param isActive 활성화 여부
     */
    void setMonthlyNoti(boolean isActive);

    /**
     * 월간 리포트 활성화 여부 확인
     * @return 활성화 여부
     */
    boolean isActiveMonthlyNoti();

    /**
     * 주간 리포트 활성화 여부 저장
     * @param isActive 활성화 여부
     */
    void setWeeklyNoti(boolean isActive);

    /**
     * 주간 리포트 활성화 여부 확인
     * @return 활성화 여부
     */
    boolean isActiveWeeklyNoti();

    /**
     * 일간 리포트 활성화 여부 저장
     * @param isActive 활성화 여부
     */
    void setDailyNoti(boolean isActive);

    /**
     * 일간 리포트 활성화 여부 확인
     * @return 일간 리포트 활성화 여부 확인
     */
    boolean isActiveDailyNoti();

    /**
     * 알림 테스트를 위한 함수
     * @param type Constants.NotificationType.DAILY, Constants.NotificationType.MONTHLY, Constants.NotificationType.WEEKLY_MON, Constants.NotificationType.WEEKLY_FRI
     * @param second 해당 초이후 알림 발생
     */
    void setReportTest(String type, int second);

    /**
     * csv 파일 내보내기 사용의 경우 file provider authority 값 전달
     * @param authority
     */
    void setAuthority(String authority);

    /**
     *
     * @param birth 태어난해 ex) 1987
     * @param sex 성별 ex) male, female
     */
    void setUserInfo(int birth, Constants.UserSex sex);

}
