package com.tenqube.visual_third.model.api;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;
import java.util.Calendar;

public class UserInfoRequest implements Serializable {

    @SerializedName("birth")
    private final int birth;

    @SerializedName("sex")
    private final String sex;

    public UserInfoRequest(int birth, String sex) throws ParameterException {

        Validator.gt(birth, 1000);
        Validator.lt(birth, Calendar.getInstance().get(Calendar.YEAR));

        Validator.in(sex, "male", "female");
        this.birth = birth;
        this.sex = sex;
    }
}
