package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.os.BuildCompat;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;

import java.util.Calendar;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;


public class AlarmReceiver extends BroadcastReceiver {

    protected static final String TAG = AlarmReceiver.class.getSimpleName();

    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION_HANA";

    public static final String ARG_NOTI_ID = "TENQUBE_ARG_NOTI_ID";
    public static final String ARG_NOTI_TEST = "TENQUBE_ARG_NOTI_TEST";

    @Override
    public void onReceive(final Context context, Intent intent) {

        final Context lContext = getContext(context);
        if(ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            try {

                int notiId = intent.getIntExtra(ARG_NOTI_ID, -1);
                final boolean isTest = intent.getBooleanExtra(ARG_NOTI_TEST, false);

                if(notiId != -1) {
                    VisualNotification notification = VisualAlarmManager.getInstance(lContext).getNotification(notiId);
                    if(notification != null &&
                        notification.isEnable()) {

                        LOGI(TAG, "start Alarm", mIsDebug);

                        // 알림이 울린시점의 시간이 저녁인경우
                        if(isTest || shouldShow(notification))
                            VisualNotificationManager.getInstance(lContext).showNotification(notification);
                    } else {
                        LOGI(TAG, "notification == null", mIsDebug);
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                VisualAlarmManager.getInstance(lContext).syncNotification();
                VisualAlarmManager.getInstance(lContext).setAlarms();
            }
        }
    }

    private boolean shouldShow(VisualNotification notification) {

        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int diff = hour - notification.getHour();

        LOGI(TAG, "hour" + hour, mIsDebug);
        LOGI(TAG, "diff" + diff, mIsDebug);
        LOGI(TAG, "Math.abs(hour - diff)" + Math.abs(diff), mIsDebug);

        return Math.abs(diff) < 3;
    }

    private Context getContext(Context context) {
        if (BuildCompat.isAtLeastN()) {
            return context.createDeviceProtectedStorageContext();
        } else {
            return context;
        }
    }
}
