/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.core.BottomDialog;
import com.tenqube.visual_third.core.BulkLoader;
import com.tenqube.visual_third.core.ProgressDialogFragment;
import com.tenqube.visual_third.core.VisualServiceImpl;
import com.tenqube.visual_third.core.WebAppInterface;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends AppCompatActivity {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int FINISH = 0;
    public static final int PROGRESS = 1;
    public static final int SHOW_PROGRESS_BAR = 2;
    public static final int ERROR = 3;
    private ProgressDialogFragment progressDialog;
    private PrefManager prefManager;
    private String path;
    private WebView webview;
    private BulkLoader bulkLoader;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Bundle bundle;
                    if (VisualWebActivity.this.progressDialog == null || !VisualWebActivity.this.progressDialog.isAdded() || (bundle = msg.getData()) == null) break;
                    VisualWebActivity.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                    break;
                }
                case 2: {
                    if (VisualWebActivity.this.progressDialog == null) {
                        VisualWebActivity.this.progressDialog = ProgressDialogFragment.newInstance();
                        VisualWebActivity.this.progressDialog.setCancelable(false);
                    }
                    try {
                        if (VisualWebActivity.this.progressDialog.isAdded()) break;
                        FragmentManager fragmentManager = VisualWebActivity.this.getSupportFragmentManager();
                        VisualWebActivity.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    VisualWebActivity.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
                    if (VisualWebActivity.this.progressDialog != null && VisualWebActivity.this.progressDialog.isAdded()) {
                        VisualWebActivity.this.progressDialog.dismiss();
                    }
                    if (VisualWebActivity.this.webview == null) break;
                    VisualWebActivity.this.webview.loadUrl(PrefManager.getInstance(VisualWebActivity.this.getApplicationContext()).loadStringValue("TENQUBE_WEB_URL", "" + VisualWebActivity.this.path));
                }
            }
            return false;
        }
    });

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            this.setContentView(R.layout.activity_visual_web);
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.webview.addJavascriptInterface((Object)new WebAppInterface((Activity)this, this.webview, new BottomDialog((Activity)this)), "visual");
            this.webview.getSettings().setJavaScriptEnabled(true);
            if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
                LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
                this.startBulkParsing();
            } else {
                this.webview.loadUrl(this.prefManager.loadStringValue("TENQUBE_WEB_URL", "") + this.path);
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(0);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.handler.sendEmptyMessage(2);
                    LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(3);
                }
            }
        }).start();
    }
}

