/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

class BulkLoader
implements BulkSmsAdapter {
    private final Context mContext;
    private Cursor mCursor;
    private final Handler mHandler;
    private final OnSmsLoadFinished onSmsLoadFinished;
    private ParserService parserService;
    private VisualApi api;
    private PrefManager prefManager;

    public BulkLoader(Context context, Handler handler, OnSmsLoadFinished onSmsLoadFinished) {
        this.mContext = context;
        this.mHandler = handler;
        this.onSmsLoadFinished = onSmsLoadFinished;
        this.prefManager = PrefManager.getInstance(context);
        this.parserService = ParserService.getInstance((Context)context);
        this.parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
    }

    public void doParsing() {
        this.initCursor();
        this.parserService.syncParsingRule(this.api.syncParsingRule());
        this.parserService.parseBulk((BulkSmsAdapter)this);
    }

    private void initCursor() {
        try {
            Uri uri = Uri.parse((String)"content://sms/inbox");
            this.mCursor = this.mContext.getContentResolver().query(uri, null, this.getWhere(), null, "date asc");
            if (this.mCursor != null) {
                this.mCursor.moveToFirst();
            }
        }
        catch (Exception e) {
            this.onError(1);
        }
    }

    private String getWhere() {
        Calendar calendar = Calendar.getInstance();
        long time = this.prefManager.loadLongValue("TENQUBE_SIGN_UP_TIME", 0L);
        if (time != 0L) {
            calendar.setTimeInMillis(time);
        }
        calendar.add(2, -6);
        return "date > " + calendar.getTimeInMillis() + " and date <= " + time;
    }

    public int getSmsCount() {
        return this.mCursor == null ? 0 : this.mCursor.getCount();
    }

    public SMS getSmsAt(int n) {
        return this.getSMS();
    }

    private SMS getSMS() {
        SMS sms = null;
        if (this.mCursor != null) {
            sms = new SMS(this.mCursor.getInt(this.mCursor.getColumnIndex("_id")), this.mCursor.getString(this.mCursor.getColumnIndex("body")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), Utils.getConvertedDate(this.mCursor.getLong(this.mCursor.getColumnIndex("date"))), Constants.SMSType.SMS.ordinal());
            this.mCursor.moveToNext();
        }
        return sms;
    }

    public void onProgress(int now, int total) {
        int percent = now * 100 / total + 1;
        Bundle data = new Bundle();
        data.putInt("percent", percent);
        data.putInt("now", now);
        data.putInt("total", total);
        this.sendHandlerMsg(data, 1, percent);
    }

    public void sendToServerTransactions(ArrayList<Transaction> transactions, OnNetworkResultListener callback) {
        this.api.searchCompany(transactions, callback);
    }

    public void onCompleted() {
        this.sendHandlerMsg(null, 0, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(false);
        }
    }

    public void onError(int resultCode) {
        this.sendHandlerMsg(null, 0, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(true);
        }
    }

    private void sendHandlerMsg(Bundle data, int what, int arg1) {
        if (this.mHandler != null) {
            Message hMsg = this.mHandler.obtainMessage();
            if (data != null) {
                hMsg.setData(data);
            }
            hMsg.what = what;
            hMsg.arg1 = arg1;
            this.mHandler.sendMessage(hMsg);
        }
    }

    public static interface OnSmsLoadFinished {
        public void onFinished(boolean var1);
    }
}

