package com.tenqube.visual_third.core;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;

import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.NewViewInfo;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;

import java.util.ArrayList;

import static com.tenqube.visual_third.util.Utils.fromJson;
import static com.tenqube.visual_third.util.Utils.toJson;

public class WebAppInterface implements BottomDialog.OnBottomListener{

    private final Activity activity;
    private final WebView webView;

    private String callbackSelectOrderBy;

    //  생성 필요한 부
    // bottom dialog
    // qliper
    // repository
    //
    private BottomDialog bottomDialog;

    public WebAppInterface(Activity activity, WebView webView, BottomDialog bottomDialog) {
        this.activity = activity;
        this.webView = webView;
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
    }

    /**
     *
     bottom dialog 노출
     * @param params {
        title: ‘정렬기준 선택',
        data: [{
        name: ‘인기순',
        orderByType: 1
        }, {
        name: ‘최신순’,
        orderByType: 2,
        }, {
        name: ‘이름순',
        orderByType: 3
        }],
        dataCallbackJS: ‘callbackSelectOrderBy’
    }
     */
    @JavascriptInterface
    public void openSelectBox(String params) {
        try {
            // params 파싱해서 callback 구하기
            SelectBoxRequest selectBoxRequest = fromJson(params, SelectBoxRequest.class);
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();

            if(bottomDialog != null) bottomDialog.showBottomDialog(selectBoxRequest);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        bottomDialog.dismiss();
        callback(callbackSelectOrderBy, selectBoxInfo);

    }



    /**

     * @param params
     *  * 3. 예시
        3-1. 내장 브라우저에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘external’,
        url: ‘https://visualbank.io’,
        titlebar: ‘N’
        }));
        ```
        3-2. 앱 내부 웹 뷰에서 해당 웹 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘internal’,
        url: ‘http://dev.kt-view.tenqube.kr/dialog’,
        titlebar: ‘Y’,
        title: '상세내역',
        titleColor: ‘#000000’,
        fontColor: ‘#ffffff’
        }));
        ```
        3-3. 구글 플레이 스토어에 해당 페이지 호출
        ```
        window.visual.openNewView( JSON.stringify({
        viewType: ‘google’,
        url: ‘https://play.google.com/store/apps/details?id=com.tenqube.qlip’,
        titlebar: ‘N’
        }));
     */
    @JavascriptInterface
    public void openNewView(String params) {

        try {

            NewViewInfo newViewInfo = fromJson(params, NewViewInfo.class);
            if(newViewInfo == null) return;

            if("external".equals(newViewInfo.getViewType())) {

                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(newViewInfo.getUrl()));
                activity.startActivity(i);

            } else if("internal".equals(newViewInfo.getViewType())) {

                VisualWebActivity.startActivity(activity, newViewInfo.getUrl());

            } else if("google".equals(newViewInfo.getViewType())) {

                GoOpenMarketUtil.openOnGooglePlayMarket(activity, newViewInfo.getUrl());

            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 화면 종료
     */
    @JavascriptInterface
    public void finish() {

        try {
            if(activity != null)
                activity.finish();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 카테고리 목록 불러오기
     * @param callback 콜백 함수명
     */
    @JavascriptInterface
    public void getCategories(String callback) {

        try {
            //start query;
            ArrayList<CategoryInfo.ServerCategory> serverCategories = new ArrayList<>();
            serverCategories.add(new CategoryInfo.ServerCategory(1, "식사", "한식",2210));
            serverCategories.add(new CategoryInfo.ServerCategory(2, "생활/마트", "대형마트",3410));

            ArrayList<CategoryInfo.UserCategory> userCategories = new ArrayList<>();
            userCategories.add(new CategoryInfo.UserCategory(1, 2210, 0,0));
            userCategories.add(new CategoryInfo.UserCategory(2, 3410, 0,0));


            CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
            callback(callback, categoryInfo);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    /**
     * 카드 목록 불러오기
     * @param callback 콜백 함수명
     */
    @JavascriptInterface
    public void getCards(String callback) {

        try {
            //start query;
            ArrayList<Cards.Card> cardList = new ArrayList<>();
            cardList.add(new Cards.Card(1, "신한", "신한", 0,0,"", "", 0, 0));
            Cards cards = new Cards(cardList);

            callback(callback, cards);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    /**
     * 조건에 맞는 내역 목록 가져오기

     * @param params {
            year: 2015,
            month: 8,
            before: 3,
            callbackJS: 'callbackTransData'
        }
     */
    @JavascriptInterface
    public void getTransactions(String params) {

        try {

            TransactionRequest transactionRequest = fromJson(params, TransactionRequest.class);

            // start query
            ArrayList<Transactions.Transaction> tranList = new ArrayList<>();
            tranList.add(new Transactions.Transaction(1, 221010, "식사", "한식", 1, 1, "", 1, "신한", 2000, 1, 0, 0, 1, "", 0, "2018-07-12 22:22:22", "2018-07-12 22:22:22", "식당키워드", "메모"));
            Transactions transactions = new Transactions(tranList);

            callback(transactionRequest.getCallbackJS(), transactions);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    /**
     * 레벨 0 목록 가져오기
     * @param callback 콜백 함수명
     */
    @JavascriptInterface
    public void getLv0Contents(String callback) {

        try {
            //start query
            ArrayList<Lv0Info.Lv0> lv0s = new ArrayList<>();
            lv0s.add(new Lv0Info.Lv0("lv0_mid_beauty_nail",
                    "뷰티/미용",
                    "네일 케어  받은 지 15일 되었습니다.",
                    "마지막으로 케어 받은 날은\n" +
                            "%s (%s) 입니다.  \n" +
                            "\n" +
                            "지난 3개월간 네일케어를 총 %s번 받았습니다."

                    ));

            lv0s.add(new Lv0Info.Lv0("lv0_mid_culture_movies",
                    "문화/예술",
                    "영화 본 지 15일 지났습니다.",
                    "마지막으로 영화 본 날은\n" +
                            "%s (%s) 입니다.  \n" +
                            "\n" +
                            "지난 3개월, 영화를 %s번 봤습니다. "

            ));


            Lv0Info lv0Info = new Lv0Info(lv0s);
            callback(callback, lv0Info);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }




    /**
     * 내역 업데이트
     * @param params {
            lCode: Number, // 대분류 코드
            mCode : Number, // 중분류 코드
            cateConfigId: Number, // 카테고리 설정 코드
            keyword: String, // 키워드
            amount: Number, // 금액
            cardId: Number, // 카드 아이디
            installmentCnt: Number, // 할부
            date: String, // 결제일
            memo: String, // 메모
            isExpense: Boolean, // 지출내역인지
            isAll: Boolean, // 모든 카테고리에 일괄적용할지
            callbackJS: 'callbackUpdateTrans' // 콜백
        }
     */
    @JavascriptInterface
    public void updateTransaction(String params) {

        try {
            UpdateTransactionRequest updateTransactionRequest = fromJson(params, UpdateTransactionRequest.class);

            // update transaction
            callback(updateTransactionRequest.getCallbackJS(), null);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void callback(final String callback, final Object object) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {

                    webView.loadUrl(getJs(callback, object == null ? "" : toJson(object)));

                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 스낵바 띄우기
     * @param msg
     */
    @JavascriptInterface
    public void showSnackBar(String msg) {

        try {
            Snackbar.make(webView, msg, Snackbar.LENGTH_SHORT).show();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 토스트 띄우기
     * @param msg
     */
    @JavascriptInterface
    public void showToast(String msg) {

        try {
            Toast.makeText(activity, msg, Toast.LENGTH_SHORT).show();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private String getJs(String callback, String data) {
        if(!TextUtils.isEmpty(data)) data = "'" + data + "'";
        return "javascript:window." + callback + "(" + data + ");";
    }

}
