package com.tenqube.visual_third.core;

import android.content.Context;
import android.location.Location;

import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.TransactionPopupActivity;

import java.util.ArrayList;

import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ResultCode;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.Constants.SAMSUNG_PAY;
import static com.tenqube.visual_third.util.Utils.shouldParsing;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

/**
 * SMS or MMS or NOTI 수신시 실행
 *
 */
class OneLoader {

    private static final String TAG = OneLoader.class.getSimpleName();
    private static OneLoader mInstance = null;
    private Context mContext;
    private final FusedLocationManager fusedLocationManager;
    private ParserService parserService;
    private int mServerCnt = 0;
    private VisualApi api;

    public static OneLoader getInstance(Context context) {

        synchronized (OneLoader.class) {
            if (mInstance == null) {
                mInstance = new OneLoader(context.getApplicationContext());
            }
        }
        return mInstance;
    }


    private OneLoader(Context context) {
        this.mContext = context;
        this.fusedLocationManager = FusedLocationManager.getInstance(context);
        this.parserService = ParserService.getInstance(context);
        this.api = VisualApi.getInstance(context);
    }

//    @SuppressLint("HandlerLeak")
//    private final Handler mHandler = new Handler() {
//        @Override
//        public void handleMessage(Message msg) {
//            if(msg.what == 200) {
//                Bundle bundle = msg.getData();
//                if(bundle != null) {
//                    TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo((Transaction)bundle.getSerializable("transaction"),
//                            (Company)bundle.getSerializable("company"));
//
//                    TransactionPopupActivity.startActivity(mContext, (transactionPopupInfo));
//                }
//
//            }
//        }
//    };


    /**
     * ParserResult의 코드에따라서 파싱된내역 서버전송, 파싱룰 동기화 안잡힌거 전송으로 분기
     * @param sms 문자 데이터
     */
    public synchronized void doParsing(final SMS sms) {

        new Thread(new Runnable() {
            @Override
            public void run() {

                LOGI(TAG, "doParsing" + sms.toString(), mIsDebug);

                fusedLocationManager.loadLastLocation();

                // 파싱
                ParserResult parserResult = parserService.parse(sms);

                // 실패하고 삼성페이인경우 title 로 파싱
                if(parserResult.resultCode != ResultCode.SEND_TO_SERVER &&
                        SAMSUNG_PAY.equals(sms.sender)) {

                    sms.fullSms = sms.title;
                    parserResult = parserService.parse(sms);

                }

                // 파싱 결과에 따른 분기
                LOGI(TAG, "parserResult" + (parserResult.resultCode) + ResultCode.stringValueOf(parserResult.resultCode), mIsDebug);

                switch(parserResult.resultCode) {
                    case ResultCode.NEED_TO_SYNC_PARSING_RULE:
                        syncParsingRule();
                        break;

                    case ResultCode.NEED_TO_SYNC_PARSING_RULE_NO_SENDER:
                        if(shouldParsing(sms.fullSms)) syncParsingRuleAndNoSender();
                        break;

                    case ResultCode.NEED_TO_SEND_TO_SERVER:
                        break;

                    case ResultCode.SEND_TO_SERVER:
                        parsedSMS(parserResult.transactions);
                        break;

                }

            }
        }).start();


    }

    private void syncParsingRuleAndNoSender() {
        mServerCnt++;
        if(mServerCnt == 5) {
            mServerCnt = 0;
            syncParsingRule();
        }
    }

    /**
     * 파싱된 경우
     * 결과값 저장 및 파싱된 내역 구글 캘린더 알림 노출 등 기존 로직 처리
     * @param transactions 파싱된 내역
     */
    private void parsedSMS(ArrayList<Transaction> transactions) {

        try {


            Transaction currentTran = getCurrentTransaction(transactions);

            // 위치정보 추가
            if(currentTran != null) {
                addLocationInfo(currentTran);
            }
            // 서버 전송
            SearchCompanyResponse searchCompanyResponse = api.searchCompany(transactions);

            if(searchCompanyResponse != null) {


                // 팝업 띄움. current Tran && 중복 아닌경
                if(currentTran != null && currentTran.isDuplicate == 0)
                    checkCurrentTranInfo(searchCompanyResponse, currentTran);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private Transaction getCurrentTransaction(ArrayList<Transaction> transactions) {

        for (Transaction transaction : transactions) {

            if (transaction.isCurrentTran) {
                return transaction;
            }
        }
        return null;
    }

    private void addLocationInfo(Transaction currentTran) {
        Location location = fusedLocationManager.getLocation();
        if (location != null) {
            currentTran.spentLatitude = location.getLatitude();
            currentTran.spentLongitude = location.getLongitude();
        } else {
            currentTran.spentLatitude = -1;
            currentTran.spentLongitude = -1;
        }
    }



    /**
     * 파싱 결과 팝업
     */
    private void checkCurrentTranInfo(final SearchCompanyResponse searchCompanyResponse, Transaction currentTran) {

        for(SearchCompanyResponse.TranCompany company : searchCompanyResponse.getResults()) {
            if(company.getIdentifier() == currentTran.identifier) {

                TransactionPopupInfo transactionPopupInfo = new TransactionPopupInfo(currentTran,
                        company);
                try {
                    TransactionPopupActivity.startActivity(mContext, (transactionPopupInfo));
                } catch (ParameterException e) {
                    e.printStackTrace();
                } catch (AuthException e) {
                    e.printStackTrace();
                }
                break;
            }
        }

    }

    /**
     * 파싱룰 서버 동기화 필요
     */
    private void syncParsingRule() {
        parserService.syncParsingRule(api.syncParsingRule());
    }


}
