package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.tenqube.visual_third.R;


public class ProgressDialogFragment extends DialogFragment {


    public static final String TAG = ProgressDialogFragment.class.getSimpleName();
    private Context context;

    private ProgressBar progressBar;
    private TextView percentTextView;
    private TextView cntTextView;

    public ProgressDialogFragment() {
        super();
    }

    public static ProgressDialogFragment newInstance(){
        return new ProgressDialogFragment();
    }

    public void setProgressValue(int now, int total, int progress) {

        progressBar.setProgress(progress);

        cntTextView.setText(now + "/" + total);

        percentTextView.setText(progress + "%");
    }


    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {
            if (context == null)
                context = getActivity();

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(context);
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_progress,null);

            progressBar = view.findViewById(R.id.progress);
            percentTextView = view.findViewById(R.id.percent);
            cntTextView = view.findViewById(R.id.cnt);

            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);

            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

}
