package com.tenqube.visual_third.model;


import java.io.Serializable;

import tenqube.parser.model.Transaction;

public class VisualTransaction implements Serializable {


    public VisualTransaction(Transaction transaction) {

        identifier = transaction.identifier;
        cardName = transaction.cardName;
        cardNum = transaction.cardNum;
        cardType = transaction.cardType;
        cardSubType = transaction.cardSubType;
        spentMoney = transaction.spentMoney;
        spentDate = transaction.spentDate;
        finishDate = transaction.finishDate;
        keyword = transaction.keyword;
        installmentCount = transaction.installmentCount;
        dwType = transaction.dwType;
        currency = transaction.currency;
        balance = transaction.balance;
        sender = transaction.sender;
        regId = transaction.regId;
        fullSms = transaction.fullSms;
        smsDate = transaction.smsDate;
        smsType = transaction.smsType;
        isOffset = transaction.isOffset;
        isDuplicate = transaction.isDuplicate;
        memo = transaction.memo;
        spentLatitude = transaction.spentLatitude;
        spentLongitude = transaction.spentLongitude;
        categoryCode = transaction.categoryCode;
        isCurrentTran = transaction.isCurrentTran;


    }

    /**
     * 클라이언트 키값
     */
    private String identifier;

    /**
     * 카드 or 은행사 이름
     */

    private String cardName;

    /**
     * 카드 or 은행 번호
     */
    private String cardNum;

    /**
     * 0:체크 1:신용 2:계좌
     */
    private int cardType;

    /**
     * 0:일반 1:법인 2:가족
     */
    private int cardSubType;


    /**
     * 사용금액
     */
    private double spentMoney;

    /**
     * 사용날짜
     */
    private String spentDate;

    /**
     * 할부 마지막 날짜
     */
    private String finishDate;

    /**
     * 키워드
     */
    private String keyword;

    /**
     * 할부 개월수
     */
    private int installmentCount;

    /**
     * 0:수입 1:지출
     */
    private int dwType;

    /**
     * 통화
     */
    private String currency;

    /**
     * 잔액
     */
    private double balance;

    private Double parsedBalance;

    private int smsId;
    /**
     * 카드사 or 은행사 전화번호
     */
    private String sender;


    /**
     * 매칭된 regId
     */
    private int regId;
    /**
     * 문자 메세지
     */
    private String fullSms;

    /**
     * 문자 날짜
     */
    private String smsDate;

    /**
     * 문자 타입
     * 0:notification 1:mms 2:sms
     */
    private int smsType;


    /**
     * 승인 - 취소 상쇄 여부
     * 0: 상쇄 안됨 1: 상쇄됨
     */
    private int isOffset;

    /**
     * 중복 여부
     * 0: 중복아님 1: 중복
     */
    private int isDuplicate;

    /**
     * 메모
     */
    private String memo;

    /**
     * 위도
     */
    private double spentLatitude;

    /**
     * 경도
     */
    private double spentLongitude;

    /**
     * 카테고리 코드
     */
    private int categoryCode;

    /**
     * 서버 성공 여부
     */
    private int isSuccess;

    /**
     * 실시간 내역 여부
     */
    private boolean isCurrentTran;

    public String getIdentifier() {
        return identifier;
    }

    public String getCardName() {
        return cardName;
    }

    public String getCardNum() {
        return cardNum;
    }

    public int getCardType() {
        return cardType;
    }

    public int getCardSubType() {
        return cardSubType;
    }

    public double getSpentMoney() {
        return spentMoney;
    }

    public String getSpentDate() {
        return spentDate;
    }

    public String getFinishDate() {
        return finishDate;
    }

    public String getKeyword() {
        return keyword;
    }

    public int getInstallmentCount() {
        return installmentCount;
    }

    public int getDwType() {
        return dwType;
    }

    public String getCurrency() {
        return currency;
    }

    public double getBalance() {
        return balance;
    }

    public Double getParsedBalance() {
        return parsedBalance;
    }

    public int getSmsId() {
        return smsId;
    }

    public String getSender() {
        return sender;
    }

    public int getRegId() {
        return regId;
    }

    public String getFullSms() {
        return fullSms;
    }

    public String getSmsDate() {
        return smsDate;
    }

    public int getSmsType() {
        return smsType;
    }

    public int getIsOffset() {
        return isOffset;
    }

    public int getIsDuplicate() {
        return isDuplicate;
    }

    public String getMemo() {
        return memo;
    }

    public double getSpentLatitude() {
        return spentLatitude;
    }

    public double getSpentLongitude() {
        return spentLongitude;
    }

    public int getCategoryCode() {
        return categoryCode;
    }

    public int getIsSuccess() {
        return isSuccess;
    }

    public boolean isCurrentTran() {
        return isCurrentTran;
    }
}
