/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.js;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.entity.Category;
import java.io.Serializable;
import java.util.ArrayList;

public class CategoryInfo
implements Serializable {
    @SerializedName(value="serverCategory")
    private ArrayList<ServerCategory> serverCategory;
    @SerializedName(value="userCategory")
    private ArrayList<UserCategory> userCategory;

    public CategoryInfo(ArrayList<ServerCategory> serverCategory, ArrayList<UserCategory> userCategory) {
        this.serverCategory = serverCategory;
        this.userCategory = userCategory;
    }

    public ArrayList<ServerCategory> getServerCategory() {
        return this.serverCategory;
    }

    public ArrayList<UserCategory> getUserCategory() {
        return this.userCategory;
    }

    public static class UserCategory
    implements Serializable {
        private int cateConfigId;
        private int categoryCode;
        private int mainType;
        private int exceptType;

        public UserCategory(com.tenqube.visual_third.entity.UserCategory userCategory) {
            this.cateConfigId = userCategory.getId();
            this.categoryCode = userCategory.getCode();
            this.mainType = userCategory.isMain() ? 1 : 0;
            this.exceptType = userCategory.isExcept() ? 1 : 0;
        }

        public int getCateConfigId() {
            return this.cateConfigId;
        }

        public int getCategoryCode() {
            return this.categoryCode;
        }

        public int getMainType() {
            return this.mainType;
        }

        public int getExceptType() {
            return this.exceptType;
        }
    }

    public static class ServerCategory
    implements Serializable {
        private int categoryId;
        private String largeCategory;
        private String mediumCategory;
        private int categoryCode;

        public ServerCategory(Category category) {
            this.categoryId = category.getId();
            this.largeCategory = category.getLarge();
            this.mediumCategory = category.getMedium();
            this.categoryCode = category.getCode();
        }

        public int getCategoryId() {
            return this.categoryId;
        }

        public String getLargeCategory() {
            return this.largeCategory;
        }

        public String getMediumCategory() {
            return this.mediumCategory;
        }

        public int getCategoryCode() {
            return this.categoryCode;
        }
    }
}

