/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.TransactionPopupInfo;
import com.tenqube.visual_third.ui.VisualWebActivity;
import java.io.Serializable;

public class TransactionPopupActivity
extends Activity {
    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    public static final String ACTION_TRANSACTION_RECEIVED = "tenqube.intent.action.ACTION_TRANSACTION_RECEIVED";

    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) throws ParameterException {
        if (transactionPopupInfo == null) {
            throw new ParameterException("Check transactionPopupInfo.");
        }
        Intent intent = new Intent(context, TransactionPopupActivity.class);
        intent.putExtra(ARG_TRANSACTION, (Serializable)transactionPopupInfo);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.overridePendingTransition(0, 0);
            this.requestWindowFeature(1);
            this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.setContentView(R.layout.activity_transaction_popup);
            DisplayMetrics dm = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(dm);
            TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo)this.getIntent().getSerializableExtra(ARG_TRANSACTION);
            if (transactionPopupInfo == null) {
                this.finish();
                return;
            }
            TextView companyTitleTextView = (TextView)this.findViewById(R.id.company_title);
            companyTitleTextView.setText((CharSequence)transactionPopupInfo.getCompanyTitle());
            TextView companyAddressTextView = (TextView)this.findViewById(R.id.company_address);
            companyAddressTextView.setText((CharSequence)transactionPopupInfo.getCompanyAddress());
            TextView spentDateTextView = (TextView)this.findViewById(R.id.spent_date);
            spentDateTextView.setText((CharSequence)transactionPopupInfo.getSpentDate());
            TextView paymentTextView = (TextView)this.findViewById(R.id.payment);
            paymentTextView.setText((CharSequence)transactionPopupInfo.getPayment());
            TextView installmentTextView = (TextView)this.findViewById(R.id.installment);
            installmentTextView.setText((CharSequence)transactionPopupInfo.getInstallmentStr());
            TextView spentMoneyTextView = (TextView)this.findViewById(R.id.spent_money);
            spentMoneyTextView.setText((CharSequence)transactionPopupInfo.getSpentMoneyStr());
            this.findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        VisualWebActivity.startActivity(TransactionPopupActivity.this.getApplicationContext(), "detail");
                    }
                    catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    finally {
                        TransactionPopupActivity.this.finish();
                    }
                }
            });
            this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TransactionPopupActivity.this.finish();
                }
            });
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(new Intent(ACTION_TRANSACTION_RECEIVED));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        this.overridePendingTransition(0, 0);
        super.onPause();
    }
}

