package com.tenqube.visual_third.model;

import android.text.TextUtils;

import java.io.Serializable;

import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.util.Utils.threeComma;

public class TransactionPopupInfo implements Serializable{

    private Transaction transaction;
    private SearchCompanyResponse.TranCompany tranCompany;


    public TransactionPopupInfo(Transaction transaction, SearchCompanyResponse.TranCompany tranCompany) {
        this.transaction = transaction;
        this.tranCompany = tranCompany;
    }

    public String getCompanyTitle() {
        return tranCompany == null ? "" : tranCompany.getCompany().getName();
    }

    public String getCompanyAddress() {
        return tranCompany == null ? "" : tranCompany.getCompany().getAddress();
    }

    public String getSpentDate() {
        return transaction == null ? "" : transaction.spentDate;
    }


    public String getPayment() {
        if(transaction == null) return "";

        String payment = transaction.cardName;
        if(!TextUtils.isEmpty(transaction.cardNum)) {
            payment += " " + transaction.cardNum;
        }
        return payment;
    }


    public int getInstallmentCnt() {
        return transaction == null ? 1 :transaction.installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "일시불" : instCnt + "개월";
    }

    public double getSpentMoney() {
        if(transaction == null) return 0;

        return transaction.spentMoney;
    }


    public String getSpentMoneyStr() {
        return threeComma(getSpentMoney());
    }

}
