/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.core.BulkLoader;
import com.tenqube.visual_third.core.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.SignUpInfo;
import com.tenqube.visual_third.ui.ProgressDialogFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int SHOW_PROGRESS_BAR = 2000;
    public static final int ERROR = 404;
    private static final String DEV_WEB_URL = "http://dev.kt-view.tenqube.kr/";
    private static final String PROD_WEB_URL = "http://prod.kt-view.tenqube.kr/";
    private PrefManager prefManager;
    private AppCompatActivity activity;
    private VisualApi api;
    private ProgressDialogFragment progressDialog;
    private BulkLoader bulkLoader;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (VisualServiceImpl.this.isActive()) {
                switch (msg.what) {
                    case 1: {
                        Bundle bundle;
                        if (VisualServiceImpl.this.progressDialog == null || !VisualServiceImpl.this.progressDialog.isAdded() || (bundle = msg.getData()) == null) break;
                        VisualServiceImpl.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        break;
                    }
                    case 2000: {
                        if (VisualServiceImpl.this.progressDialog == null) {
                            VisualServiceImpl.this.progressDialog = ProgressDialogFragment.newInstance();
                            VisualServiceImpl.this.progressDialog.setCancelable(false);
                        }
                        try {
                            if (VisualServiceImpl.this.progressDialog.isAdded()) break;
                            FragmentManager fragmentManager = VisualServiceImpl.this.activity.getSupportFragmentManager();
                            VisualServiceImpl.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                        }
                        catch (ClassCastException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 404: {
                        if (VisualServiceImpl.this.progressDialog == null || !VisualServiceImpl.this.progressDialog.isAdded()) break;
                        VisualServiceImpl.this.progressDialog.dismiss();
                        break;
                    }
                }
            }
            return false;
        }
    });

    public VisualServiceImpl(@NonNull AppCompatActivity activity) throws ParameterException {
        if (activity == null) {
            throw new ParameterException("activity is null");
        }
        this.activity = activity;
        this.prefManager = PrefManager.getInstance((Context)activity);
        this.api = VisualApi.getInstance((Context)activity);
        this.bulkLoader = new BulkLoader((Context)activity, this.handler, new BulkLoader.OnSmsLoadFinished(){

            @Override
            public void onFinished(boolean isError) {
                try {
                    if (VisualServiceImpl.this.handler != null) {
                        VisualServiceImpl.this.handler.sendEmptyMessage(404);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void startBulkParsing(final String custId) throws ParameterException, SecurityException {
        LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
        if (this.isActive()) {
            Validator.isCustId(custId);
            if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECEIVE_MMS") != 0) {
                throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogUtil.LOGI((String)TAG, (String)"3. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                        VisualServiceImpl.this.handler.sendEmptyMessage(2000);
                        LogUtil.LOGI((String)TAG, (String)"4. \uac00\uc785 \ub3d9\uae30\ud615\ud0dc\ub85c \uad6c\uc131", (boolean)ParserService.mIsDebug);
                        VisualServiceImpl.this.api.signUp(new SignUpInfo(custId));
                        LogUtil.LOGI((String)TAG, (String)"5. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                        VisualServiceImpl.this.bulkLoader.doParsing();
                    }
                    catch (Exception e) {
                        VisualServiceImpl.this.handler.sendEmptyMessage(404);
                    }
                }
            }).start();
        }
    }

    @Override
    public void startVisualWeb() throws AuthException {
        if (TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_CUST_ID", ""))) {
            throw new AuthException("CustId is empty");
        }
        try {
            VisualWebActivity.startActivity((Context)this.activity, "main");
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive()) {
            ParserService.getInstance((Context)this.activity).setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive()) {
            ParserService.getInstance((Context)this.activity).initDb();
        }
    }

    private boolean isActive() {
        return this.activity != null && !this.activity.isFinishing();
    }
}

