/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;

public class VisualProvider
extends ContentProvider {
    private static final UriMatcher sUriMatcher = new UriMatcher(-1);
    private VisualRepository repository;

    public boolean onCreate() {
        this.repository = VisualRepository.getInstance(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            String[] dates;
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int groupType = sUriMatcher.match(uri);
            switch (groupType) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    dates = Utils.getDateRange(year, month, 0);
                    break;
                }
                case 2: {
                    dates = Utils.getWeeklyDateRanges(0).toArray(new String[0]);
                    break;
                }
                default: {
                    return null;
                }
            }
            Cursor cursor = this.repository.getSum(dates[0], dates[1], groupType);
            return cursor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    static {
        sUriMatcher.addURI("tenqube.provider", "month", 1);
        sUriMatcher.addURI("tenqube.provider", "week", 2);
        sUriMatcher.addURI("tenqube.provider", "card", 3);
        sUriMatcher.addURI("tenqube.provider", "category", 4);
        sUriMatcher.addURI("tenqube.provider", "keyword", 5);
    }
}

