/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.ExcelManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.StatusManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BaseActivity;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.OnFinishListener;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualPermissionActivity;
import com.tenqube.visual_third.util.PathUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.util.permission.AfterPermissionGranted;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends BaseActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
PermissionUtil.PermissionCallbacks,
ActivityCallback {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int PERMISSION_REQUEST_CODE = 0;
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int VISUAL_REQUEST_CODE = 512;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    private PrefManager prefManager;
    private VisualApi api;
    private VisualRepository repository;
    private ResourceManager resourceManager;
    private VisualAlarmManager alarmManager;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private String path;
    private WebView webview;
    private BulkLoader bulkLoader;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private LinearLayout errorView;
    private boolean isError;
    private FrameLayout webContainer;
    private CardView adContainer;
    private boolean isLoading;
    private BroadcastReceiver transactionReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                final int tranId = intent.getIntExtra("tranId", 0);
                VisualWebActivity.this.webview.post(new Runnable(){

                    @Override
                    public void run() {
                        if (tranId != 0) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onTransactionReceived(" + tranId + ");");
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        if (VisualWebActivity.this.webview != null && (bundle = msg.getData()) != null) {
                            VisualWebActivity.this.webview.loadUrl("javascript:window.onProgress(" + bundle.getInt("now") + "," + bundle.getInt("total") + ");");
                        }
                        break;
                    }
                    case 12: {
                        VisualWebActivity.this.isLoading = true;
                        VisualWebActivity.this.loadProgressUrl();
                        break;
                    }
                    case 10: {
                        VisualWebActivity.this.onBulkFinish(true);
                        break;
                    }
                    default: {
                        VisualWebActivity.this.onBulkFinish(false);
                    }
                }
            }
            catch (Exception e) {
                VisualWebActivity.this.onBulkFinish(false);
            }
            return false;
        }
    });
    public static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int STORAGE = 1;
    public Callback<Boolean> completion;

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("VisualWebActivity"));
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.repository = VisualRepository.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.resourceManager = ResourceManager.getInstance(this.api, this.prefManager, ParserService.getInstance((Context)this.getApplicationContext()));
            this.alarmManager = VisualAlarmManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            if (this.path == null) {
                this.path = "";
            }
            LogUtil.LOGI((String)"PATH", (String)this.path, (boolean)true);
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    AnalysisServiceImpl.shouldRefresh = true;
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webContainer = (FrameLayout)this.findViewById(R.id.web_container);
            this.errorView = (LinearLayout)this.findViewById(R.id.error_container);
            this.errorView.setVisibility(8);
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.errorInterface = new ErrorImpl(this, this.webview);
            this.logInterface = new LogImpl(this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl(this, this.webview, this.errorInterface, this.repository, VisualApi.getInstance(this.getApplicationContext()), new AnalysisServiceImpl((Context)this, ""), this.alarmManager);
            this.uiInterface = new UiImpl(this, this.webview, this.errorInterface, new BottomDialog(this), AdManager.getInstance(this.getApplicationContext()));
            this.systemInterface = new SystemImpl(this, this.webview, this.errorInterface);
            this.actionInterface = new ActionImpl(this, this.webview);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            this.webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
            WebViewHelper.settings(this.webview, this.repository.isDev());
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    VisualWebActivity.this.loadErrorUrl();
                }
            });
            if (this.shouldRequestOverlayPermission()) {
                VisualPermissionActivity.startActivity(this, 0);
            } else {
                this.startVisual();
            }
        }
        catch (Exception e) {
            this.finish();
        }
        StatusManager.getInstance().setOnFinishListener(new OnFinishListener(){

            @Override
            public void onFinish() {
                VisualWebActivity.this.finish();
            }
        });
    }

    private void startVisual() {
        this.loadUrl(this.path);
        if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
            LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
            this.startBulkParsing();
        } else {
            this.alarmManager.setAlarms();
            this.resourceManager.sync();
        }
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
        this.completion = callback;
        this.exportExcel();
    }

    @Override
    public Context getContext() {
        return this.getApplicationContext();
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    private void loadUrl(String path) {
        if (this.webview != null) {
            this.isPageLoaded = false;
            if (path == null) {
                path = "";
            }
            String url = WebViewHelper.getBaseUrl(this.prefManager) + path;
            this.webview.loadUrl(url);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        this.errorView.setVisibility(0);
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.transactionReceiver, new IntentFilter("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
        this.repository.setVisualActive(true);
        this.overridePendingTransition(0, 0);
    }

    @Override
    public void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.transactionReceiver);
        this.repository.setVisualActive(false);
        this.overridePendingTransition(0, 0);
    }

    private void onBulkFinish(boolean isSuccess) {
        this.isLoading = false;
        this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
        if (this.webview != null) {
            this.startVisual();
        }
        if (this.completion != null) {
            this.completion.onDataLoaded(isSuccess);
            this.completion = null;
        }
    }

    private void loadProgressUrl() {
        if (this.webview != null) {
            this.isPageLoaded = false;
            String webUrl = WebViewHelper.getProgressUrl(this.prefManager, Constants.ProgressType.BULK);
            this.webview.loadUrl(webUrl);
        }
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VisualWebActivity.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    VisualWebActivity.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 0: {
                if (this.shouldRequestOverlayPermission()) {
                    this.finish();
                    break;
                }
                this.startVisual();
                break;
            }
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.systemInterface == null) break;
                    this.systemInterface.onNotiCallback(json);
                    break;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void addAd(View view) {
        try {
            this.webContainer.addView((View)this.createCardView(view));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CardView createCardView(View view) {
        this.adContainer = new CardView((Context)this);
        this.adContainer.setCardElevation(this.getResources().getDimension(R.dimen.elevation));
        if (Build.VERSION.SDK_INT >= 21) {
            this.adContainer.setElevation(this.getResources().getDimension(R.dimen.elevation));
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(16));
        params.gravity = 80;
        this.adContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.adContainer.setRadius((float)Utils.dpToPx(13));
        this.adContainer.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
        this.adContainer.addView(view);
        return this.adContainer;
    }

    @Override
    public void hideAd() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (VisualWebActivity.this.adContainer != null) {
                        VisualWebActivity.this.webContainer.removeView((View)VisualWebActivity.this.adContainer);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return null;
    }

    @Override
    public void setStatusBarColor(String color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    @AfterPermissionGranted(value=1)
    public void exportExcel() {
        if (PermissionUtil.hasPermissions((Context)this, PERMISSIONS_STORAGE)) {
            ExcelManager.getInstance((Context)this).export(new ExcelManager.Callback(){

                @Override
                public void onCompleted(File file) {
                    boolean isSuccess;
                    boolean bl = isSuccess = file != null;
                    if (isSuccess) {
                        String applicationId = VisualWebActivity.this.prefManager.loadStringValue("TENQUBE_APPLICATION_ID", VisualWebActivity.this.getApplicationContext().getPackageName());
                        try {
                            BaseActivity.skipFlag = true;
                            Intent intent = new Intent("android.intent.action.SEND");
                            intent.setType("application/octet-stream");
                            intent.addFlags(262144);
                            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Utils.getUri(VisualWebActivity.this.getApplicationContext(), applicationId, file));
                            VisualWebActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\uacf5\uc720"));
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)VisualWebActivity.this.getString(R.string.export_excel_success_msg, new Object[]{file.getName()}), (int)0).show();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            String log = "pkgName:" + applicationId + "\n FileProvider Error";
                            Toast.makeText((Context)VisualWebActivity.this.getApplicationContext(), (CharSequence)log, (int)0).show();
                            VisualWebActivity.this.completion.onDataLoaded(false);
                            return;
                        }
                    }
                    VisualWebActivity.this.completion.onDataLoaded(isSuccess);
                }
            });
        } else {
            PermissionUtil.requestPermissions(this, 1, PERMISSIONS_STORAGE);
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> list) {
        if (requestCode == 1) {
            this.exportExcel();
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> list) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30\ub97c \uc704\ud574 \uc678\ubd80 \uc800\uc7a5\uc18c\uc5d0 \ub300\ud55c \uad8c\ud55c\uc774 \ud544\uc694\ud569\ub2c8\ub2e4. \uad8c\ud55c\uc774 \uc5c6\ub294 \uacbd\uc6b0 \uc5d1\uc140 \ud30c\uc77c \ub0b4\ubcf4\ub0b4\uae30 \uc0ac\uc6a9\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.", (int)0).show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    public static void startActivity(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance((Context)activity).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        BaseActivity.skipFlag = true;
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        activity.startActivityForResult(intent, 512);
    }

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        BaseActivity.skipFlag = true;
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public static void startActivity(@NonNull Context context, @NonNull PopupData popupData) throws AuthException, ParameterException {
        Validator.notNull(context);
        Validator.notNull(popupData);
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        BaseActivity.skipFlag = true;
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, PathUtil.makePath(popupData));
        intent.addFlags(262144);
        intent.addFlags(335675392);
        context.startActivity(intent);
    }

    public boolean shouldRequestOverlayPermission() {
        return PermissionUtil.shouldRequestOverlayPermission(this.getApplicationContext()) && this.repository.shouldShowTranPopup();
    }
}

