/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AdManager;
import com.tenqube.visual_third.manager.Lv0DataCache;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.AdRequest;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.ActivityCallback;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.web.ActionImpl;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.VisualInterface;
import java.io.Serializable;
import java.util.Calendar;

public class TransactionPopupActivity
extends AppCompatActivity
implements ActivityCallback {
    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    private FrameLayout webContainer;
    private CardView adContainer;
    private TransactionPopupInfo transactionPopupInfo;
    private boolean isPageLoaded;
    private Lv0Info.Lv0 lv0;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private VisualInterface.Action actionInterface;
    private VisualRepository repository;

    public static void start(Context context, TransactionPopupInfo transactionPopupInfo) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        try {
            Intent intent = new Intent(context, TransactionPopupActivity.class);
            intent.addFlags(1409417216);
            intent.putExtra(ARG_TRANSACTION, (Serializable)transactionPopupInfo);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.transactionPopupInfo = (TransactionPopupInfo)this.getIntent().getSerializableExtra(ARG_TRANSACTION);
            this.repository = VisualRepository.getInstance(this.getApplicationContext());
            if (this.transactionPopupInfo == null || !this.repository.shouldShowTranPopup()) {
                this.finish();
                return;
            }
            this.onWebViewCreated();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish();
        }
    }

    private void onWebViewCreated() {
        this.setContentView(R.layout.visual_activity_transaction_web_popup);
        WebView webView = (WebView)this.findViewById(R.id.webview);
        webView.setBackgroundColor(0);
        this.webContainer = (FrameLayout)this.findViewById(R.id.web_container);
        this.setupWebView(webView);
    }

    private void setupWebView(final WebView webview) {
        this.errorInterface = new ErrorImpl(this, webview);
        this.logInterface = new LogImpl(this, webview, this.errorInterface);
        this.repoInterface = new RepoImpl(this, webview, this.errorInterface, this.repository, VisualApi.getInstance(this.getApplicationContext()), new AnalysisServiceImpl((Context)this, ""), VisualAlarmManager.getInstance(this.getApplicationContext()));
        this.uiInterface = new UiImpl(this, webview, this.errorInterface, new BottomDialog((Activity)this), AdManager.getInstance(this.getApplicationContext()));
        this.systemInterface = new SystemImpl(this, webview, this.errorInterface);
        this.actionInterface = new ActionImpl(this, webview);
        webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
        webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
        webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
        webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
        webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
        webview.addJavascriptInterface((Object)this.actionInterface, "visualAction");
        WebViewHelper.settings(webview, this.repository.isDev());
        webview.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                webview.setVisibility(8);
                TransactionPopupActivity.this.onAndroidViewCreated();
            }
        });
        webview.loadUrl(WebViewHelper.getPopupUrl(PrefManager.getInstance(this.getApplicationContext())));
    }

    private void onAndroidViewCreated() {
        this.findViewById(R.id.native_view).setVisibility(0);
        ImageView iconImageView = (ImageView)this.findViewById(R.id.icon);
        ImageView closeImageView = (ImageView)this.findViewById(R.id.close);
        closeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TransactionPopupActivity.this.overridePendingTransition(0, 0);
                TransactionPopupActivity.this.finish();
            }
        });
        TextView appNameTextView = (TextView)this.findViewById(R.id.app_name);
        this.setAppInfo(iconImageView, appNameTextView);
        TextView keywordTextView = (TextView)this.findViewById(R.id.keyword);
        keywordTextView.setText((CharSequence)this.transactionPopupInfo.getCompanyTitle());
        TextView amountTextView = (TextView)this.findViewById(R.id.amount);
        amountTextView.setText((CharSequence)this.transactionPopupInfo.getSpentMoneyStr());
        TextView addressTextView = (TextView)this.findViewById(R.id.address);
        addressTextView.setText((CharSequence)this.transactionPopupInfo.getCompanyAddress());
        TextView dateTextView = (TextView)this.findViewById(R.id.date);
        dateTextView.setText((CharSequence)this.transactionPopupInfo.getTransaction().getTransaction().getSpentDate());
        TextView cardTextView = (TextView)this.findViewById(R.id.card);
        cardTextView.setText((CharSequence)this.transactionPopupInfo.getPayment());
        TextView lContentTextView = (TextView)this.findViewById(R.id.lContent);
        if (Lv0DataCache.getInstance().lv0s == null || Lv0DataCache.getInstance().lv0s.isEmpty()) {
            double sum = this.repository.getSum(this.getMonthFrom(), this.getMonthEnd());
            lContentTextView.setText((CharSequence)String.format("\uc774\ubc88 \ub2ec \uc9c0\ucd9c\uc740\n %1$s \uc785\ub2c8\ub2e4.", AnalysisHelper.getLv0Currency(sum)));
        } else {
            this.lv0 = Lv0DataCache.getInstance().getLv0(this.transactionPopupInfo.getTransaction().getCategory().getLarge());
            lContentTextView.setText((CharSequence)this.lv0.getlContent());
        }
        CardView moreCardView = (CardView)this.findViewById(R.id.more);
        moreCardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    String path = "";
                    if (TransactionPopupActivity.this.lv0 != null) {
                        path = "&lv0popup=" + Utils.toJson(TransactionPopupActivity.this.lv0);
                    }
                    VisualWebActivity.startActivity(TransactionPopupActivity.this.getApplicationContext(), path);
                }
                catch (AuthException e) {
                    e.printStackTrace();
                }
                finally {
                    TransactionPopupActivity.this.finish();
                }
            }
        });
        this.webContainer = (FrameLayout)this.findViewById(R.id.adContainer);
        this.loadAd();
    }

    private String getMonthFrom() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return Utils.getStringDateAsYYYYMMddHHmmss(calendar);
    }

    private String getMonthEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return Utils.getStringDateAsYYYYMMddHHmmss(calendar);
    }

    private void setAppInfo(ImageView iconImageView, TextView title) {
        PackageManager packageManager = this.getApplicationContext().getPackageManager();
        try {
            String pkgName = this.getApplicationContext().getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(pkgName, 128);
            Drawable icon = packageManager.getApplicationIcon(pkgName);
            iconImageView.setImageDrawable(icon);
            String appName = (String)packageManager.getApplicationLabel(appInfo);
            title.setText((CharSequence)appName);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private void loadAd() {
        AdRequest adRequest = new AdRequest();
        adRequest.unitId = "ca-app-pub-1003660361092577/9395305141";
        AdManager.getInstance(this.getApplicationContext()).loadAd(adRequest, new OnAdLoadedListener(){

            @Override
            public void onAdLoaded(View view) {
                try {
                    TransactionPopupActivity.this.webContainer.addView((View)TransactionPopupActivity.this.createCardView(view));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void exportExcel(Callback<Boolean> callback) {
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    @Override
    public Context getContext() {
        return this.getApplicationContext();
    }

    public AppCompatActivity getActivity() {
        return this;
    }

    @Override
    public void onPagedLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                TransactionPopupActivity.this.isPageLoaded = true;
            }
        });
    }

    @Override
    public void onScrollChanged(int pos) {
    }

    @Override
    public void reload() {
    }

    @Override
    public void retry() {
    }

    @Override
    public void setRefreshEnabled(boolean enabled) {
    }

    private CardView createCardView(View view) {
        this.adContainer = new CardView((Context)this);
        this.adContainer.setCardElevation(this.getResources().getDimension(R.dimen.elevation));
        if (Build.VERSION.SDK_INT >= 21) {
            this.adContainer.setElevation(this.getResources().getDimension(R.dimen.elevation));
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMargins(Utils.dpToPx(10), Utils.dpToPx(16), Utils.dpToPx(10), Utils.dpToPx(72));
        params.gravity = 80;
        this.adContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.adContainer.setRadius((float)Utils.dpToPx(13));
        this.adContainer.setCardBackgroundColor(Color.parseColor((String)"#00000000"));
        this.adContainer.addView(view);
        return this.adContainer;
    }

    @Override
    public void addAd(View view) {
        try {
            this.webContainer.addView((View)this.createCardView(view));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void hideAd() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TransactionPopupActivity.this.adContainer != null) {
                        TransactionPopupActivity.this.webContainer.removeView((View)TransactionPopupActivity.this.adContainer);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.stay, 0);
    }

    public void onResume() {
        super.onResume();
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }

    @Override
    public TransactionPopupInfo getPopUpInfo() {
        return this.transactionPopupInfo;
    }

    @Override
    public void setStatusBarColor(String color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.getWindow().setStatusBarColor(Color.parseColor((String)color2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

