/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.os.BuildCompat;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;
import java.util.Calendar;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class AlarmReceiver
extends BroadcastReceiver {
    protected static final String TAG = AlarmReceiver.class.getSimpleName();
    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION_IBK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Context lContext = this.getContext(context);
        if (ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            try {
                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {
                    VisualNotification notification = (VisualNotification)bundle.getSerializable("data");
                    if (notification != null && notification.isEnable() && !"daily".equals(notification.getName()) && VisualAlarmManager.getInstance(lContext).isActiveNoti(notification.getId())) {
                        LogUtil.LOGI((String)TAG, (String)"start Alarm", (boolean)ParserService.mIsDebug);
                        if (this.shouldShow(notification)) {
                            VisualNotificationManager.getInstance(lContext).showNotification(notification);
                        }
                    } else {
                        LogUtil.LOGI((String)TAG, (String)"notification == null", (boolean)ParserService.mIsDebug);
                    }
                } else {
                    LogUtil.LOGI((String)TAG, (String)"bundle == null", (boolean)ParserService.mIsDebug);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                VisualAlarmManager.getInstance(lContext).syncNotification();
                VisualAlarmManager.getInstance(lContext).setAlarms();
            }
        }
    }

    private boolean shouldShow(VisualNotification notification) {
        if (notification.isTest()) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int diff = hour - notification.getHour();
        LogUtil.LOGI((String)TAG, (String)("hour" + hour), (boolean)ParserService.mIsDebug);
        LogUtil.LOGI((String)TAG, (String)("diff" + diff), (boolean)ParserService.mIsDebug);
        LogUtil.LOGI((String)TAG, (String)("Math.abs(hour - diff)" + Math.abs(diff)), (boolean)ParserService.mIsDebug);
        return Math.abs(diff) < 3;
    }

    private Context getContext(Context context) {
        if (BuildCompat.isAtLeastN()) {
            return context.createDeviceProtectedStorageContext();
        }
        return context;
    }
}

