/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.AdRequest;

public class AdManager {
    public static final String TAG = AdManager.class.getSimpleName();
    public static final String AD_ID = "ca-app-pub-1003660361092577~2282746668";
    public static final String UNIT_ID = "ca-app-pub-1003660361092577/9395305141";
    private static AdManager mInstance = null;
    private Context mContext;
    AdRequest adRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdManager getInstance(Context ctx) {
        Class<AdManager> clazz = AdManager.class;
        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AdManager(Context context) {
        this.mContext = context;
        try {
            MobileAds.initialize((Context)context, (String)AD_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAd(AdRequest adRequest, @NonNull OnAdLoadedListener listener) {
        this.adRequest = adRequest;
        this.loadAdmob(adRequest.unitId, listener);
    }

    private View populateUnifiedNativeAdView(UnifiedNativeAd nativeAd, UnifiedNativeAdView adView) {
        String linkToBgColor;
        String linkToColor;
        String titleColor;
        String bgColor;
        if (this.adRequest.container != null) {
            bgColor = this.adRequest.container.bgColor;
            titleColor = this.adRequest.container.textColor;
        } else {
            bgColor = "#f0fbff";
            titleColor = "#000000";
        }
        if (this.adRequest.button != null) {
            linkToColor = this.adRequest.button.textColor;
            linkToBgColor = this.adRequest.button.bgColor;
        } else {
            linkToColor = "#ffffff";
            linkToBgColor = "#3684ff";
        }
        this.setBgColor((View)adView, bgColor);
        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.msg));
        adView.setCallToActionView(adView.findViewById(R.id.link_text));
        if (TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)nativeAd.getCallToAction())) {
            return null;
        }
        ((TextView)adView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        this.setTextColor((TextView)adView.getHeadlineView(), titleColor);
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(4);
        } else {
            adView.getBodyView().setVisibility(0);
            ((TextView)adView.getBodyView()).setText((CharSequence)nativeAd.getBody());
        }
        adView.getCallToActionView().setVisibility(0);
        ((TextView)adView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
        this.setTextColor((TextView)adView.getCallToActionView(), linkToColor);
        this.setBgColor(adView.findViewById(R.id.linkto), linkToBgColor);
        if (nativeAd.getIcon() == null || nativeAd.getIcon().getDrawable() == null) {
            adView.getIconView().setVisibility(8);
            adView.findViewById(R.id.icon_image_container).setVisibility(8);
        } else {
            ((ImageView)adView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(0);
        }
        adView.setNativeAd(nativeAd);
        return adView;
    }

    private void loadAdmob(String unitId, final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(this.mContext, unitId);
        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                UnifiedNativeAdView adView = (UnifiedNativeAdView)LayoutInflater.from((Context)AdManager.this.mContext).inflate(R.layout.visual_admob_view, null);
                AdManager.this.populateUnifiedNativeAdView(unifiedNativeAd, adView);
                if (listener != null) {
                    listener.onAdLoaded((View)adView);
                }
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                if (listener != null) {
                    listener.onAdLoaded(null);
                }
            }
        }).build();
        com.google.android.gms.ads.AdRequest nativeAdRequest = new AdRequest.Builder().build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable2 = (GradientDrawable)view.getBackground();
                drawable2.setColor(Color.parseColor((String)bgColor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                view.setTextColor(Color.parseColor((String)textColor));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

