/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.VisualNotification;
import java.util.ArrayList;

public class NotificationDao {
    private final Db db;

    public NotificationDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveNoti(int id2) {
        String query = QueryGenerator.isActive(id2);
        int enabled = 0;
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    enabled = c.getInt(0);
                    c.moveToNext();
                }
            }
        }
        return enabled == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveNoti(String name) {
        String query = QueryGenerator.isActive(name);
        int enabled = 0;
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    enabled = c.getInt(0);
                    c.moveToNext();
                }
            }
        }
        return enabled == 1;
    }

    public void setActiveNoti(String name, boolean isActive) {
        try {
            ContentValues values = new ContentValues();
            values.put("noti_enable", Integer.valueOf(isActive ? 1 : 0));
            long affectedRow = this.db.update(" NOTIFICATIONS ", values, "noti_name like '%" + name + "%'", null);
            System.out.print(affectedRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateNotiHour(String name, int hour) {
        try {
            ContentValues values = new ContentValues();
            values.put("noti_hour", Integer.valueOf(hour));
            this.db.update(" NOTIFICATIONS ", values, "noti_name=?", new String[]{name});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateNotiStatus(int id2, boolean enabled) {
        try {
            ContentValues values = new ContentValues();
            values.put("noti_enable", Integer.valueOf(enabled ? 1 : 0));
            this.db.update(" NOTIFICATIONS ", values, "noti_id_pk=?", new String[]{"" + id2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualNotification loadNotification(String name) {
        String query = QueryGenerator.notification(name);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                VisualNotification visualNotification = ReaderContract.NotificationsTable.populateModel(c);
                return visualNotification;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<VisualNotification> loadNotifications() {
        String query = QueryGenerator.notification();
        ArrayList<VisualNotification> results = new ArrayList<VisualNotification>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.NotificationsTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void updateNotiSetting(VisualNotification notification) {
        try {
            ContentValues values = new ContentValues();
            values.put("noti_enable", Integer.valueOf(notification.isEnable() ? 1 : 0));
            this.db.update(" NOTIFICATIONS ", values, "noti_id_pk=?", new String[]{notification.getId() + ""});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mergeNotifications(@NonNull ArrayList<VisualNotification> notifications) {
        try {
            for (VisualNotification notification : notifications) {
                ContentValues values = ReaderContract.NotificationsTable.populateContent(notification);
                this.db.insertOnReplace(" NOTIFICATIONS ", values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

