/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.text.TextUtils;
import com.tenqube.visual_third.analysis.FunctionMap;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.CAC;
import com.tenqube.visual_third.model.analysis.CategoryAvg;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Result;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.util.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AnalysisHelper {
    static final String KEY_DELIMITER = ";";
    private static final DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private static final DecimalFormat decimalFormatWithDot = new DecimalFormat("###,###.#");

    static HashMap<String, AggregationValue> aggregate(ArrayList<Transaction> transactions, int ... keys) {
        HashMap<String, AggregationValue> results = new HashMap<String, AggregationValue>();
        for (Transaction transaction : transactions) {
            String key = AnalysisHelper.makeKey(transaction, keys);
            AggregationValue aggregation = results.get(key);
            if (aggregation != null) {
                aggregation.setSum(aggregation.getSum() + transaction.getTransaction().getSpentMoney());
                aggregation.setCnt(aggregation.getCnt() + 1);
                aggregation.setAvg();
                aggregation.getTranIds().add(transaction.getTransaction().getId());
            } else {
                ArrayList<Integer> tranIds = new ArrayList<Integer>();
                tranIds.add(transaction.getTransaction().getId());
                aggregation = new AggregationValue(key, transaction.getTransaction().getSpentMoney(), 1, transaction.getTransaction().getSpentMoney(), tranIds);
                aggregation.setTitle(AnalysisHelper.getTitle(transaction, keys.length > 0 ? keys[0] : 0));
            }
            results.put(key, aggregation);
        }
        return results;
    }

    private static String makeKey(Transaction transaction, int ... keys) {
        ArrayList<String> aggregateKey = new ArrayList<String>();
        block9: for (int key : keys) {
            switch (key) {
                case 2: {
                    aggregateKey.add(transaction.getCategory().getLargeCode());
                    continue block9;
                }
                case 1: {
                    aggregateKey.add(Utils.getYMD(transaction.getTransaction().getSpentDate()));
                    continue block9;
                }
                case 3: {
                    aggregateKey.add(transaction.getCategory().getLargeMediumCode());
                    continue block9;
                }
                case 4: {
                    aggregateKey.add("" + transaction.getCard().getChangeType());
                    continue block9;
                }
                case 5: {
                    aggregateKey.add("" + transaction.getTransaction().getFranchise());
                    continue block9;
                }
                case 6: {
                    aggregateKey.add("" + transaction.getTransaction().getKeyword());
                    continue block9;
                }
                case 7: {
                    aggregateKey.add("" + Utils.getYMD(transaction.getTransaction().getSpentDate()));
                    continue block9;
                }
                default: {
                    aggregateKey.add("");
                }
            }
        }
        return TextUtils.join((CharSequence)KEY_DELIMITER, aggregateKey);
    }

    private static String getTitle(Transaction transaction, int key) {
        String title;
        switch (key) {
            case 6: {
                title = transaction.getTransaction().getKeyword();
                break;
            }
            case 2: {
                title = transaction.getCategory().getLarge();
                break;
            }
            case 3: {
                title = transaction.getCategory().getMedium();
                break;
            }
            case 4: {
                title = transaction.getCategory().getMedium();
                break;
            }
            case 7: {
                title = Utils.getYMD(transaction.getTransaction().getSpentDate());
                break;
            }
            default: {
                title = "";
            }
        }
        return title;
    }

    static int getMonth(int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        return calendar.get(2) + 1;
    }

    static ArrayList<Transaction> filterTransactions(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransaction = new ArrayList<Transaction>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        String monthStr = Utils.getYM(calendar);
        for (Transaction transaction : transactions) {
            if (!monthStr.equals(Utils.getYM(transaction.getTransaction().getSpentDate()))) continue;
            filteredTransaction.add(transaction);
        }
        return filteredTransaction;
    }

    static double getSamePeriodSum(ArrayList<Transaction> transactions, int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        double sum = 0.0;
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(transaction.getTransaction().getSpentDate(), Utils.getYMD(calendar))) continue;
            sum += transaction.getTransaction().getSpentMoney();
        }
        return sum;
    }

    static ArrayList<Transaction> filterTransactionsDaily(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        ArrayList<String> dateRanges = Utils.getDailyDateRanges(before);
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(dateRanges.get(0), transaction.getTransaction().getSpentDate()) || !Utils.compareDate(transaction.getTransaction().getSpentDate(), dateRanges.get(1))) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static ArrayList<Transaction> filterTransactionsWeekly(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        ArrayList<String> dateRanges = Utils.getWeeklyDateRanges(before);
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(dateRanges.get(0), transaction.getTransaction().getSpentDate()) || !Utils.compareDate(transaction.getTransaction().getSpentDate(), dateRanges.get(1))) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static ArrayList<Transaction> filterTransactionsMcode(ArrayList<Transaction> transactions, int ... mcodes) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        for (Transaction transaction : transactions) {
            boolean isMatched = true;
            for (int mcode : mcodes) {
                if (String.valueOf(mcode).equals(transaction.getCategory().getLargeMediumCode())) continue;
                isMatched = false;
                break;
            }
            if (!isMatched) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static ArrayList<Transaction> filterTransactionsByDate(ArrayList<Transaction> transactions, String date) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        for (Transaction transaction : transactions) {
            if (!date.equals(Utils.getYMD(transaction.getTransaction().getSpentDate()))) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static double getSumByLcode(ArrayList<Transaction> transactions, int lCode, String date) {
        double sum = 0.0;
        for (Transaction transaction : transactions) {
            if (!String.valueOf(lCode).equals(transaction.getCategory().getLargeCode()) || !Utils.compareDateBefore(Utils.getYMD(transaction.getTransaction().getSpentDate()), date)) continue;
            sum += transaction.getTransaction().getSpentMoney();
        }
        return sum;
    }

    static Morning getMorningSum(ArrayList<Transaction> transactions, int mcode) {
        int fromHour = 7;
        int toHour = 10;
        double sum = 0.0;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Transaction transaction : transactions) {
            Calendar calendar;
            int hour;
            if (!String.valueOf(mcode).equals(transaction.getCategory().getLargeMediumCode()) || fromHour > (hour = (calendar = Utils.toCalendar(transaction.getTransaction().getSpentDate())).get(11)) || hour >= toHour) continue;
            sum += transaction.getTransaction().getSpentMoney();
            ids.add(transaction.getTransaction().getId());
        }
        return new Morning(sum, ids);
    }

    static Transaction getMaxKeyword(ArrayList<Transaction> transactions) {
        Transaction maxTransaction = null;
        for (Transaction transaction : transactions) {
            if (maxTransaction == null || maxTransaction.getTransaction().getSpentMoney() < transaction.getTransaction().getSpentMoney()) {
                maxTransaction = transaction;
                continue;
            }
            if (maxTransaction.getTransaction().getSpentMoney() != transaction.getTransaction().getSpentMoney()) continue;
            if (Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate())) {
                maxTransaction = transaction;
                continue;
            }
            if (!Utils.equalsDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate()) || maxTransaction.getTransaction().getId() >= transaction.getTransaction().getId()) continue;
            maxTransaction = transaction;
        }
        return maxTransaction;
    }

    static Transaction getMaxSpentDate(ArrayList<Transaction> transactions) {
        Transaction maxTransaction = null;
        for (Transaction transaction : transactions) {
            if (maxTransaction == null || Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate())) {
                maxTransaction = transaction;
                continue;
            }
            if (!Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate()) || maxTransaction.getTransaction().getId() >= transaction.getTransaction().getId()) continue;
            maxTransaction = transaction;
        }
        return maxTransaction;
    }

    static boolean isSatisfied(Condition condition) {
        try {
            if (condition == null) {
                return false;
            }
            String[] values = AnalysisHelper.getValues(condition.getFuncKeys().split(","));
            if (values == null || values.length == 0 || TextUtils.isEmpty((CharSequence)values[0])) {
                return false;
            }
            switch (condition.getFuncType()) {
                case "=": {
                    return Double.parseDouble(condition.getStandard()) == Double.parseDouble(values[0]);
                }
                case "<": {
                    return Double.parseDouble(condition.getStandard()) < Double.parseDouble(values[0]);
                }
                case ">": {
                    return Double.parseDouble(condition.getStandard()) > Double.parseDouble(values[0]);
                }
                case ">=": {
                    return Double.parseDouble(condition.getStandard()) >= Double.parseDouble(values[0]);
                }
                case "<=": {
                    return Double.parseDouble(condition.getStandard()) <= Double.parseDouble(values[0]);
                }
                case "!=": {
                    return Double.parseDouble(condition.getStandard()) != Double.parseDouble(values[0]);
                }
                case "function*<": {
                    return Double.parseDouble(values[0]) * Double.parseDouble(condition.getStandard()) < Double.parseDouble(values[1]);
                }
                case "function*>": {
                    return Double.parseDouble(values[0]) * Double.parseDouble(condition.getStandard()) > Double.parseDouble(values[1]);
                }
                case "date=": {
                    return Utils.equalsDate(condition.getStandard(), values[0]);
                }
                case "date<": {
                    return Utils.ltDate(condition.getStandard(), values[0]);
                }
                case "date>": {
                    return Utils.gtDate(condition.getStandard(), values[0]);
                }
                case "date<=": {
                    return Utils.compareDate(condition.getStandard(), values[0]);
                }
                case "date>=": {
                    return Utils.compareDate(values[0], condition.getStandard());
                }
                case "odd": {
                    return Utils.isOddDay();
                }
                case "even": {
                    return Utils.isEvenDay();
                }
                case "True": {
                    return true;
                }
                case "isEmpty": {
                    if ("0".equals(condition.getStandard())) {
                        return !TextUtils.isEmpty((CharSequence)values[0]);
                    }
                    return TextUtils.isEmpty((CharSequence)values[0]);
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String[] getValues(String[] keys) {
        String[] funcResults = new String[keys.length];
        int i = 0;
        for (String key : keys) {
            String value;
            funcResults[i] = value = AnalysisHelper.getFuncValue(Integer.parseInt(key));
            ++i;
        }
        return funcResults;
    }

    static String getContent(String content, String funcKey) throws Exception {
        if (TextUtils.isEmpty((CharSequence)funcKey) || "none".equals(funcKey)) {
            return content;
        }
        String[] funcKeys = funcKey.split(",");
        String[] values = new String[funcKey.length()];
        for (int i = 0; i < funcKeys.length; ++i) {
            Result result = (Result)FunctionMap.values.get(Integer.parseInt(funcKeys[i].replace(" ", "")));
            if (result == null) {
                throw new Exception();
            }
            values[i] = result.getDisplayValue();
        }
        return String.format(content, values);
    }

    static String getValue(String image) {
        try {
            int key = Integer.parseInt(image);
            String imagePath = AnalysisHelper.getFuncValue(key);
            if (!TextUtils.isEmpty((CharSequence)imagePath)) {
                image = imagePath;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return image;
    }

    static ArrayList<Integer> getTranIds(JoinedContent content) {
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        try {
            String[] rawKeys;
            for (String rawKey : rawKeys = content.getContent().getRawKeys().split(",")) {
                ArrayList temIds = (ArrayList)FunctionMap.tranIds.get(Integer.parseInt(rawKey));
                if (Utils.isEmpty(temIds)) continue;
                tranIds.addAll(temIds);
            }
            return tranIds;
        }
        catch (Exception exception) {
            return tranIds;
        }
    }

    public static String getLv0Currency(double amount) {
        if (amount < 1000.0) {
            return decimalFormat.format(amount) + "\uc6d0";
        }
        return decimalFormatWithDot.format(amount / 10000.0) + "\ub9cc\uc6d0";
    }

    public static String getNumber(double amount) {
        return decimalFormat.format(amount) + "\uc6d0";
    }

    public static String getPercent(double value) {
        if (value == 0.0) {
            return "0.0 %";
        }
        return decimalFormatWithDot.format(value) + "%";
    }

    public static String getCnt(double value, String unit) {
        return decimalFormatWithDot.format(value) + unit;
    }

    public static String getNumberFirst(double value) {
        return decimalFormatWithDot.format(value);
    }

    static String[] getAlcoholType(int cnt) {
        if (cnt == 0) {
            return new String[]{"\ube44\uc74c\uc8fc", "lv0_alcohol_type_no_alcohol"};
        }
        if (cnt > 0 && cnt <= 2) {
            return new String[]{"\uac74\uac15 \uc911\uc2dc\ud615", "lv0_alcohol_type_healthy"};
        }
        if (cnt > 2 && cnt <= 5) {
            return new String[]{"\uc2a4\ud2b8\ub808\uc2a4 \ud574\uc18c", "lv0_alcohol_type_stress_down"};
        }
        if (cnt > 5 && cnt <= 8) {
            return new String[]{"\uc560\uc8fc\uac00\ud615", "lv0_alcohol_type_lover"};
        }
        if (cnt > 8) {
            return new String[]{"\ubc25\ubcf4\ub2e4 \uc220", "lv0_alcohol_type_prefer_al"};
        }
        return new String[]{"\ube44\uc74c\uc8fc", "lv0_alcohol_type_no_alcohol"};
    }

    static String[] getCoffeeCountry(double weekAvg) {
        if (23.0 < weekAvg) {
            return new String[]{"\ub178\ub974\uc6e8\uc774", "25\uc794/1\uc8fc\uc77c"};
        }
        if (20.0 < weekAvg && weekAvg <= 23.0) {
            return new String[]{"\uc2a4\uc704\uc2a4", "22\uc794/1\uc8fc\uc77c"};
        }
        if (17.0 < weekAvg && weekAvg <= 20.0) {
            return new String[]{"\uce90\ub098\ub2e4", "19\uc794/1\uc8fc\uc77c"};
        }
        if (14.0 < weekAvg && weekAvg <= 17.0) {
            return new String[]{"\ube0c\ub77c\uc9c8", "16\uc794/1\uc8fc\uc77c"};
        }
        if (11.8 < weekAvg && weekAvg <= 14.0) {
            return new String[]{"\ubbf8\uad6d", "13\uc794/1\uc8fc\uc77c"};
        }
        if (8.5 < weekAvg && weekAvg <= 11.8) {
            return new String[]{"\uc77c\ubcf8", "11\uc794/1\uc8fc\uc77c"};
        }
        if (5.5 < weekAvg && weekAvg <= 8.5) {
            return new String[]{"\ud55c\uad6d", "6\uc794/1\uc8fc\uc77c"};
        }
        if (3.0 < weekAvg && weekAvg <= 5.5) {
            return new String[]{"\ub7ec\uc2dc\uc544", "5\uc794/1\uc8fc\uc77c"};
        }
        if (2.2 < weekAvg && weekAvg <= 3.0) {
            return new String[]{"\ud0dc\uad6d", "3\uc794/1\uc8fc\uc77c"};
        }
        if (0.97 < weekAvg && weekAvg <= 2.2) {
            return new String[]{"\uc774\uc9d1\ud2b8", "2\uc794/1\uc8fc\uc77c"};
        }
        return new String[]{"\uc778\ub3c4", "1\uc794 \uc774\ud558/1\uc8fc\uc77c"};
    }

    static double getAggregate(HashMap<String, AggregationValue> map, String key, int agType) {
        double result = 0.0;
        try {
            if (map != null && map.get(key) != null) {
                switch (agType) {
                    case 0: {
                        return map.get(key).getSum();
                    }
                    case 1: {
                        return map.get(key).getCnt();
                    }
                    case 2: {
                        return map.get(key).getAvg();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static ArrayList<Integer> getAggregatedTranIds(HashMap<String, AggregationValue> map, String key) {
        try {
            if (map != null && map.get(key) != null) {
                return map.get(key).getTranIds();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<Integer>();
    }

    static double getPercentValue(double first, double divider) {
        if (divider == 0.0) {
            return 0.0;
        }
        return (first - divider) * 100.0 / Math.abs(divider);
    }

    static void descCate(ArrayList<CategoryAvg> values) {
        Collections.sort(values, new Comparator<CategoryAvg>(){

            @Override
            public int compare(CategoryAvg f1, CategoryAvg f2) {
                return f1.getSum() > f2.getSum() ? -1 : 1;
            }
        });
    }

    static void desc(ArrayList<AggregationValue> values) {
        Collections.sort(values, new Comparator<AggregationValue>(){

            @Override
            public int compare(AggregationValue f1, AggregationValue f2) {
                return f1.getSum() > f2.getSum() ? -1 : 1;
            }
        });
    }

    static void descAnalysis(ArrayList<Analysis> values) {
        Collections.sort(values, new Comparator<Analysis>(){

            @Override
            public int compare(Analysis f1, Analysis f2) {
                return f1.getCategoryPriority() > f2.getCategoryPriority() ? -1 : 1;
            }
        });
    }

    static void descCAC(ArrayList<CAC> values) {
        Collections.sort(values, new Comparator<CAC>(){

            @Override
            public int compare(CAC f1, CAC f2) {
                return f1.getSum() > f2.getSum() ? -1 : 1;
            }
        });
    }

    public static void asc(ArrayList<CAC> values) {
        Collections.sort(values, new Comparator<CAC>(){

            @Override
            public int compare(CAC f1, CAC f2) {
                return f1.getSum() > f2.getSum() ? 1 : -1;
            }
        });
    }

    static String getLargeImages(String lcode, boolean isRandom) {
        try {
            String[] images = AnalysisHelper.getLargeImages(Integer.parseInt(lcode));
            List<String> items = Arrays.asList(images);
            if (isRandom) {
                Collections.shuffle(items);
            }
            return items.get(0);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String[] getLargeImages(int lcode) {
        switch (lcode) {
            case 22: {
                return new String[]{"lv0_food_else_1", "lv0_mid_food_chinese", "lv0_mid_food_dining_place", "lv0_mid_food_fam_re", "lv0_mid_food_fastfood_1", "lv0_mid_food_gogi", "lv0_mid_food_japanese", "lv0_mid_food_korean", "lv0_mid_food_late_night", "lv0_mid_food_western", "lv0_mid_chicken"};
            }
            case 24: {
                return new String[]{"lv0_cafe_else_1", "lv0_mid_cafe_bakery", "lv0_mid_cafe_coffee", "lv0_mid_cafe_dessert", "lv0_mid_cafe_donut"};
            }
            case 26: {
                return new String[]{"lv0_alcohol_else", "lv0_alcohol_soolzip_yesterday", "lv0_mid_alcohol_soolzip", "lv0_mid_alcohol_entertainment"};
            }
            case 32: {
                return new String[]{"lv0_mart_else", "lv0_mid_mart_grocery", "lv0_mid_mart_conveni", "lv0_mid_mart_dailyitems", "lv0_mid_mart_events_flower", "lv0_mid_mart_housework", "lv0_mid_mart_kids_1", "lv0_mid_mart_pets"};
            }
            case 34: {
                return new String[]{"lv0_online_else", "lv0_mid_online_homeshop"};
            }
            case 36: {
                return new String[]{"lv0_shopping_else", "lv0_mid_shopping_sportbrand"};
            }
            case 42: {
                return new String[]{"lv0_finance_else", "lv0_mid_finance_insurance", "lv0_mid_finance_tax"};
            }
            case 44: {
                return new String[]{"lv0_healthcare_else", "lv0_mid_healthcare_clinic", "lv0_mid_healthcare_dentist", "lv0_mid_healthcare_healthproduct", "lv0_mid_healthcare_pharmacy"};
            }
            case 46: {
                return new String[]{"lv0_beauty_else_1", "lv0_mid_beauty_nail", "lv0_mid_beauty_hairshop", "lv0_mid_beauty_makeup", "lv0_mid_beauty_skin"};
            }
            case 52: {
                return new String[]{"lv0_livings_else", "lv0_mid_livings_telecom"};
            }
            case 54: {
                return new String[]{"lv0_education_else", "lv0_mid_education_academy", "lv0_mid_education_school"};
            }
            case 56: {
                return new String[]{"lv0_culture_else", "lv0_mid_culture_movies", "lv0_mid_culture_books", "lv0_mid_culture_hobby"};
            }
            case 62: {
                return new String[]{"lv0_transportation_else", "lv0_mid_transportation_gas", "lv0_mid_transportation_taxi", "lv0_mid_transportation_car", "lv0_mid_transportation_masstransit"};
            }
            case 64: {
                return new String[]{"lv0_leports_else"};
            }
            case 66: {
                return new String[]{"lv0_travel_else", "lv0_mid_travel_sightseeing", "lv0_mid_travel_hotel"};
            }
            case 82: {
                return new String[]{"lv0_family_event_else"};
            }
        }
        return new String[]{"lv0_uncate_else"};
    }

    static String getMidImg(String mcode) {
        switch (mcode) {
            case "6613": {
                return "lv0_mid_travel_hotel";
            }
            case "6614": {
                return "lv0_mid_travel_sightseeing";
            }
            case "6212": {
                return "lv0_mid_transportation_gas";
            }
            case "6216": {
                return "lv0_mid_transportation_taxi";
            }
            case "6213": {
                return "lv0_mid_transportation_car";
            }
            case "6214": {
                return "lv0_mid_transportation_masstransit";
            }
            case "5611": {
                return "lv0_mid_culture_movies";
            }
            case "5612": {
                return "lv0_mid_culture_books";
            }
            case "5615": {
                return "lv0_mid_culture_hobby";
            }
            case "5411": {
                return "lv0_mid_education_academy";
            }
            case "5414": {
                return "lv0_mid_education_school";
            }
            case "5211": {
                return "lv0_mid_livings_telecom";
            }
            case "4614": {
                return "lv0_mid_beauty_nail";
            }
            case "4611": {
                return "lv0_mid_beauty_hairshop";
            }
            case "4612": {
                return "lv0_mid_beauty_skin";
            }
            case "4610": {
                return "lv0_mid_beauty_makeup";
            }
            case "4413": {
                return "lv0_mid_healthcare_clinic";
            }
            case "4412": {
                return "lv0_mid_healthcare_dentist";
            }
            case "4416": {
                return "lv0_mid_healthcare_healthproduct";
            }
            case "4414": {
                return "lv0_mid_healthcare_pharmacy";
            }
            case "4212": {
                return "lv0_mid_finance_insurance";
            }
            case "4211": {
                return "lv0_mid_finance_tax";
            }
            case "3614": {
                return "lv0_mid_shopping_sportbrand";
            }
            case "3411": {
                return "lv0_mid_online_homeshop";
            }
            case "3216": {
                return "lv0_mid_mart_grocery";
            }
            case "3211": {
                return "lv0_mid_mart_conveni";
            }
            case "3213": {
                return "lv0_mid_mart_dailyitems";
            }
            case "3217": {
                return "lv0_mid_mart_events_flower";
            }
            case "3212": {
                return "lv0_mid_mart_housework";
            }
            case "3214": {
                return "lv0_mid_mart_kids_1";
            }
            case "3215": {
                return "lv0_mid_mart_pets";
            }
            case "2613": {
                return "lv0_mid_alcohol_soolzip";
            }
            case "2611": {
                return "lv0_mid_alcohol_entertainment";
            }
            case "2414": {
                return "lv0_mid_cafe_bakery";
            }
            case "2411": {
                return "lv0_mid_cafe_coffee";
            }
            case "2415": {
                return "lv0_mid_cafe_dessert";
            }
            case "2416": {
                return "lv0_mid_cafe_donut";
            }
            case "2215": {
                return "lv0_mid_food_chinese";
            }
            case "2217": {
                return "lv0_mid_food_dining_place";
            }
            case "2213": {
                return "lv0_mid_food_fam_re";
            }
            case "2212": {
                return "lv0_mid_food_fastfood_1";
            }
            case "2222": {
                return "lv0_mid_food_gogi";
            }
            case "2216": {
                return "lv0_mid_food_japanese";
            }
            case "2211": {
                return "lv0_mid_food_korean";
            }
            case "2224": {
                return "lv0_mid_food_late_night";
            }
            case "2218": {
                return "lv0_mid_food_western";
            }
            case "2214": {
                return "lv0_mid_chicken";
            }
        }
        return AnalysisHelper.getLargeImages(mcode.substring(0, 2), false);
    }

    static double getFuncAmount(int key) {
        Result result = (Result)FunctionMap.values.get(key);
        if (result == null) {
            return 0.0;
        }
        return result.getAmount();
    }

    private static String getFuncValue(int key) {
        Result result = (Result)FunctionMap.values.get(key);
        if (result == null) {
            return "";
        }
        return result.getValue();
    }

    static ArrayList<Integer> getTranIds(ArrayList<Transaction> transactions) {
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        for (Transaction transaction : transactions) {
            tranIds.add(transaction.getTransaction().getId());
        }
        return tranIds;
    }
}

