package com.tenqube.visual_third.util;

import android.text.TextUtils;

import java.text.DecimalFormat;
import java.util.Calendar;

public class Utils {

    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");// decimalformat은
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static boolean shouldParsing(String msg) {

        int cnt = 0;

        if(TextUtils.isEmpty(msg)) return false;

        if(msg.contains("원")) ++cnt;

        if(msg.contains(".")) ++cnt;

        if(msg.contains(",")) ++cnt;

        if(cnt == 3) return true;

        if(msg.contains("/")) ++cnt;

        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return getStringDateAsYYYYMMddHHmmss(cal);
    }


    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {

        try {
            if (cal == null) cal = Calendar.getInstance();

            return cal.get(Calendar.YEAR) + "-" +
                    DECIMAL_FORMAT.format((cal.get(Calendar.MONTH) + 1)) + "-" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.DATE)) + " " +
                    DECIMAL_FORMAT.format(cal.get(Calendar.HOUR_OF_DAY)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.MINUTE)) + ":" +
                    DECIMAL_FORMAT.format(cal.get(Calendar.SECOND));
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "";
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long) value) + "원";
    }

}
