/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.VersionResponse;

public class ResourceManager {
    private final VisualApi visualApi;
    private final PrefManager prefManager;
    private static ResourceManager mInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceManager getInstance(VisualApi visualApi, PrefManager prefManager) {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            if (mInstance == null) {
                mInstance = new ResourceManager(visualApi, prefManager);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return mInstance;
        }
    }

    private ResourceManager(VisualApi visualApi, PrefManager prefManager) {
        this.visualApi = visualApi;
        this.prefManager = prefManager;
    }

    public void sync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] authInfos = ResourceManager.this.visualApi.getAuthInfo();
                    VersionResponse versionResponse = ResourceManager.this.visualApi.syncVersion(authInfos[0]);
                    ResourceManager.this.syncCategory(authInfos, versionResponse);
                    ResourceManager.this.syncAnalysis(authInfos, versionResponse);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void syncCategory(String[] authInfos, VersionResponse versionResponse) {
        int version = this.prefManager.loadIntValue("TENQUBE_CATEGORY_VERSION", 11);
        if (versionResponse != null && versionResponse.getCategory() > version) {
            this.visualApi.syncCategory(authInfos, version);
        }
    }

    private void syncAnalysis(String[] authInfos, VersionResponse versionResponse) {
        int version = this.prefManager.loadIntValue("TENQUBE_ANALYSIS_VERSION", 0);
        if (versionResponse != null && versionResponse.getAnalysis() > version) {
            this.visualApi.syncAnalysis(authInfos, version);
        }
    }
}

