/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.content.Context;
import android.util.SparseArray;
import com.tenqube.visual_third.db.DatabaseHelper;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class AnalysisRepository {
    private static AnalysisRepository mInstance;
    private final ContentsDao contentsDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalysisRepository getInstance(Context context) {
        Class<AnalysisRepository> clazz = AnalysisRepository.class;
        synchronized (AnalysisRepository.class) {
            if (mInstance == null) {
                mInstance = new AnalysisRepository(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AnalysisRepository(Context context) {
        DatabaseHelper dbHelper = DatabaseHelper.getInstance(context);
        Db db = new Db(dbHelper.getWritableDatabase(), dbHelper.getReadableDatabase());
        this.contentsDao = new ContentsDao(db);
    }

    public ArrayList<JoinedContent> loadContents() {
        ArrayList<Content> contents = this.contentsDao.loadContents();
        SparseArray<ArrayList<Condition>> conditionMaps = this.contentsDao.loadConditions();
        ArrayList<JoinedContent> results = new ArrayList<JoinedContent>();
        for (Content content : contents) {
            results.add(new JoinedContent(content, (ArrayList)conditionMaps.get(content.getId())));
        }
        return results;
    }

    public void mergeAnalysis(ArrayList<AnalysisResponse.Content> contents) {
        for (AnalysisResponse.Content content : contents) {
            if (content.getEnable() == 0) {
                this.contentsDao.deleteContent(content.getId());
                continue;
            }
            this.contentsDao.mergeContent(content);
            if (Utils.isEmpty(content.getConditions())) continue;
            for (AnalysisResponse.Condition condition : content.getConditions()) {
                if (condition.getEnable() == 0) {
                    this.contentsDao.deleteCondition(condition.getId());
                    continue;
                }
                this.contentsDao.mergeCondition(condition);
            }
        }
    }
}

