/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.AppExecutors;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jxl.CellView;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Blank;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ExcelManager {
    WritableCellFormat titleFormat;
    private static final String DATE = "\ub0a0\uc9dc";
    private static final String STATE = "\uc0c1\ud0dc";
    private static final String AMOUNT = "\uae08\uc561";
    private static final String KEYWORD = "\ub0b4\uc5ed";
    private static final String PAYMENT = "\uacb0\uc81c\uc218\ub2e8";
    private static final String CATEGORY = "\uce74\ud14c\uace0\ub9ac";
    private static final String MEMO = "\uba54\ubaa8";
    private static final String[] COLUMS = new String[]{"\ub0a0\uc9dc", "\uc0c1\ud0dc", "\uae08\uc561", "\ub0b4\uc5ed", "\uacb0\uc81c\uc218\ub2e8", "\uce74\ud14c\uace0\ub9ac", "\uba54\ubaa8"};
    public static final String FILE_NAME = "ibk-visual.xls";
    private static ExcelManager mInstance = null;
    private Context mContext;
    private VisualRepository repository;
    private AppExecutors appExecutors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelManager getInstance(Context ctx) {
        Class<ExcelManager> clazz = ExcelManager.class;
        synchronized (ExcelManager.class) {
            if (mInstance == null) {
                mInstance = new ExcelManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void destroy() {
        mInstance = null;
    }

    private ExcelManager(Context context) {
        this.mContext = context;
        this.repository = VisualRepository.getInstance(context);
        this.appExecutors = new AppExecutors();
        try {
            this.titleFormat = this.createTitleFormat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File createFile() throws IOException {
        File deviceFile;
        File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!(deviceFile = new File(path, FILE_NAME)).exists()) {
            deviceFile.createNewFile();
        }
        return deviceFile;
    }

    private WritableCellFormat createTitleFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        WritableCellFormat titleFormat = new WritableCellFormat(times10pt);
        titleFormat.setWrap(false);
        titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        titleFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return titleFormat;
    }

    private WritableCellFormat createNumberFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        NumberFormat numberFormat = new NumberFormat("###,###");
        WritableCellFormat integerFormat = new WritableCellFormat(times10pt, (DisplayFormat)numberFormat);
        integerFormat.setWrap(false);
        integerFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
        integerFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return integerFormat;
    }

    private WritableCellFormat createDateTimeFormat() throws Exception {
        WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
        DateFormat userdatafmt = new DateFormat("yyyy-MM-DD hh:mm:ss");
        WritableCellFormat dataformat = new WritableCellFormat(times10pt, (DisplayFormat)userdatafmt);
        dataformat.setWrap(false);
        dataformat.setVerticalAlignment(VerticalAlignment.CENTRE);
        dataformat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.WHITE);
        return dataformat;
    }

    public void export(final Callback completion) {
        this.appExecutors.diskIO().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AssetManager am = ExcelManager.this.mContext.getAssets();
                File deviceFile = null;
                try {
                    InputStream inStream = am.open(ExcelManager.FILE_NAME);
                    Workbook tempWorkbook = Workbook.getWorkbook((InputStream)inStream);
                    deviceFile = ExcelManager.this.createFile();
                    WritableWorkbook writableWorkbook = Workbook.createWorkbook((File)deviceFile, (Workbook)tempWorkbook);
                    WritableSheet excelSheet = writableWorkbook.getSheet(0);
                    ExcelManager.this.addHeaders(excelSheet);
                    ArrayList<JoinedTransaction> transactions = ExcelManager.this.repository.loadJoinedTransactions();
                    int row = 1;
                    for (JoinedTransaction transaction : transactions) {
                        ExcelManager.this.addLines(excelSheet, transaction, row);
                        ++row;
                    }
                    writableWorkbook.write();
                    writableWorkbook.close();
                    File finalDeviceFile = deviceFile;
                    ExcelManager.this.appExecutors.mainThread().execute(new Runnable(finalDeviceFile){
                        final /* synthetic */ File val$finalDeviceFile;
                        {
                            this.val$finalDeviceFile = file;
                        }

                        @Override
                        public void run() {
                            completion.onCompleted(this.val$finalDeviceFile);
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        File finalDeviceFile = deviceFile;
                        ExcelManager.this.appExecutors.mainThread().execute(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Throwable throwable) {
                        File finalDeviceFile = deviceFile;
                        ExcelManager.this.appExecutors.mainThread().execute(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
        });
    }

    private void addLabel(WritableSheet sheet, int column, int row, String s, WritableCellFormat titleFormat, CellView cv) {
        try {
            cv.setFormat((CellFormat)titleFormat);
            if (s == null || TextUtils.isEmpty((CharSequence)s)) {
                Blank blank = new Blank(column, row, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)blank);
                sheet.setColumnView(row, cv);
            } else {
                Label label = new Label(column, row, s, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)label);
                sheet.setColumnView(row, cv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNumber(WritableSheet sheet, int column, int row, int spentMoney, CellView cv, WritableCellFormat integerFormat) {
        try {
            cv.setFormat((CellFormat)integerFormat);
            Number number = new Number(column, row, (double)spentMoney, (CellFormat)integerFormat);
            sheet.addCell((WritableCell)number);
            sheet.setColumnView(row, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDate(WritableSheet sheet, int column, int row, Calendar s, WritableCellFormat titleFormat, CellView cv, WritableCellFormat dataformat) {
        try {
            if (s == null) {
                cv.setFormat((CellFormat)titleFormat);
                Blank blank = new Blank(column, row, (CellFormat)titleFormat);
                sheet.addCell((WritableCell)blank);
                sheet.setColumnView(row, cv);
            } else {
                Date now = s.getTime();
                cv.setFormat((CellFormat)dataformat);
                DateTime datetime = new DateTime(column, row, now, (CellFormat)dataformat);
                sheet.addCell((WritableCell)datetime);
                sheet.setColumnView(row, cv);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addHeaders(WritableSheet sheet) {
        int size = COLUMS.length;
        CellView cv = new CellView();
        cv.setAutosize(true);
        for (int column = 0; column < size; ++column) {
            this.addLabel(sheet, column, 0, COLUMS[column], this.titleFormat, cv);
        }
    }

    private void addLines(WritableSheet sheet, JoinedTransaction transaction, int row) {
        try {
            CellView cv = new CellView();
            cv.setAutosize(true);
            int size = COLUMS.length;
            block20: for (int column = 0; column < size; ++column) {
                switch (COLUMS[column]) {
                    case "\ub0a0\uc9dc": {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getSpentDate(), this.titleFormat, cv);
                        continue block20;
                    }
                    case "\uc0c1\ud0dc": {
                        String state = transaction.getTransaction().getSpentMoney() < 0.0 ? "\ucde8\uc18c" : "\uc2b9\uc778";
                        this.addLabel(sheet, column, row, state, this.titleFormat, cv);
                        continue block20;
                    }
                    case "\uae08\uc561": {
                        int spentMoney = (int)transaction.getTransaction().getSpentMoney();
                        this.addLabel(sheet, column, row, "" + spentMoney, this.titleFormat, cv);
                        continue block20;
                    }
                    case "\ub0b4\uc5ed": {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getKeyword(), this.titleFormat, cv);
                        continue block20;
                    }
                    case "\uacb0\uc81c\uc218\ub2e8": {
                        this.addLabel(sheet, column, row, "" + transaction.getCard().getName(), this.titleFormat, cv);
                        continue block20;
                    }
                    case "\uce74\ud14c\uace0\ub9ac": {
                        this.addLabel(sheet, column, row, "" + transaction.getCategory().getLarge(), this.titleFormat, cv);
                        continue block20;
                    }
                    case "\uba54\ubaa8": {
                        this.addLabel(sheet, column, row, "" + transaction.getTransaction().getMemo(), this.titleFormat, cv);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback {
        public void onCompleted(File var1);
    }
}

