package com.tenqube.visual_third.model.js;

import android.text.TextUtils;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.notNull;

public class NotiRequest extends Request implements Serializable {

    private String title; // 2018-10-10

    private String callbackJS;

    public NotiRequest(String title, String callbackJS) {
        this.title = title;
        this.callbackJS = callbackJS;
    }

    public String getTitle() {
        return title;
    }

    public String getCallbackJS() {
        return callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        Validator.isStr(title, 200);
        notNull(callbackJS);
    }

}
