/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.ClipCategory;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import java.util.ArrayList;

public class ClipCategoryDao {
    private final Db db;

    public ClipCategoryDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ClipCategory> loadCategories() {
        String query = QueryGenerator.clipCategory();
        ArrayList<ClipCategory> results = new ArrayList<ClipCategory>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.ClipCategoryTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipCategory loadCategory(String categoryCode) {
        String query = QueryGenerator.clipCategory(categoryCode);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                ClipCategory clipCategory = ReaderContract.ClipCategoryTable.populateModel(c);
                return clipCategory;
            }
        }
        return null;
    }

    public void mergeCategory(SyncCategoryResponse.Category category) {
        try {
            if (category.isDeleted()) {
                this.db.delete(" CATEGORIES ", "_id=?", new String[]{category.getId() + ""});
            } else {
                ContentValues values = new ContentValues();
                values.put("_id", Integer.valueOf(category.getId()));
                values.put("cateCode", Integer.valueOf(category.getCategoryCode()));
                values.put("largeName", category.getLargeCategory());
                values.put("mediumName", category.getMediumCategory());
                values.put("smallName", category.getSmallCategory());
                this.db.insertOnReplace(" CATEGORIES ", values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

