package com.tenqube.visual_third.model.api;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SignUpRequest {

    @SerializedName("uid")
    private final String custId;

    @SerializedName("adId")
    private String adId;

    public SignUpRequest(@NonNull String custId) throws ParameterException {
        isStr(custId, 500);
        this.custId = custId;
        this.adId = adId;
    }

    public void setAdId(@Nullable String adId) {
        this.adId = adId;
    }

    public String getCustId() {
        return custId;
    }
}
