package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.util.SparseArray;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.model.api.AnalysisResponse;

import java.util.ArrayList;

public class ContentsDao {

    private final Db db;

    public ContentsDao(Db db) {
        this.db = db;
    }

    public ArrayList<Content> loadContents() {

        String query = QueryGenerator.contents();
        ArrayList<Content> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.ContentTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public SparseArray<ArrayList<Condition>> loadConditions() {

        String query = QueryGenerator.conditions();
        SparseArray<ArrayList<Condition>> results = new SparseArray<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        Condition condition = ReaderContract.ConditionTable.populateModel(c);

                        ArrayList<Condition> conditions  = results.get(condition.getcId());
                        if(conditions == null) {
                            conditions = new ArrayList<>();
                            conditions.add(condition);
                        } else {
                            conditions.add(condition);
                        }
                        results.put(condition.getcId(), conditions);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public void deleteContent(int cId) {
        db.delete(ReaderContract.ContentTable.TABLE_NAME, ReaderContract.ContentTable.COLUMN_CONTENT_ID + "= " + cId, null);
        db.delete(ReaderContract.ConditionTable.TABLE_NAME, ReaderContract.ConditionTable.COLUMN_CONTENT_ID + "= " + cId, null);
    }

    public void mergeContent(AnalysisResponse.Content content) {

        try {

            ContentValues values = new ContentValues();
            values.put(ReaderContract.ContentTable.COLUMN_CONTENT_ID, content.getId());
            values.put(ReaderContract.ContentTable.COLUMN_PRIORITY, content.getPriority());
            values.put(ReaderContract.ContentTable.COLUMN_CATEGORY_PRIORITY, content.getCategoryPriority());
            values.put(ReaderContract.ContentTable.COLUMN_NUM_OF_OCCURRENCE, content.getNumOfOccurence());
            values.put(ReaderContract.ContentTable.COLUMN_LARGE_CODE, content.getlCode());
            values.put(ReaderContract.ContentTable.COLUMN_RAW_KEYS, content.getRawKeys());
            values.put(ReaderContract.ContentTable.COLUMN_LINK_TO, content.getLinkTo());
            values.put(ReaderContract.ContentTable.COLUMN_LABEL, content.getLabel());
            values.put(ReaderContract.ContentTable.COLUMN_LARGE_CONTENT, content.getlContent().replace("\n", "\\n"));
            values.put(ReaderContract.ContentTable.COLUMN_LARGE_KEYS, content.getlKeys());
            values.put(ReaderContract.ContentTable.COLUMN_MEDIUM_CONTENT, content.getmContent().replace("\n", "\\n"));
            values.put(ReaderContract.ContentTable.COLUMN_MEDIUM_KEYS, content.getmKeys());
            values.put(ReaderContract.ContentTable.COLUMN_IMAGE, content.getImage().replace("\n", "\\n"));
            db.insertOnReplace(ReaderContract.ContentTable.TABLE_NAME, values);

        } catch (Exception e) {

        }
    }

    public void deleteCondition(int id) {
        try {
            db.delete(ReaderContract.ConditionTable.TABLE_NAME, ReaderContract.ConditionTable.COLUMN_CONDITION_ID + "= ?", new String[]{id + ""});
        } catch (Exception e) {

        }
    }

    public void mergeCondition(AnalysisResponse.Condition condition) {
        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.ConditionTable.COLUMN_CONDITION_ID, condition.getId());
            values.put(ReaderContract.ConditionTable.COLUMN_STANDARD, condition.getStandard());
            values.put(ReaderContract.ConditionTable.COLUMN_FUNC_TYPE, condition.getFuncType());
            values.put(ReaderContract.ConditionTable.COLUMN_FUNC_KEYS, condition.getFuncKeys());
            db.insertOnReplace(ReaderContract.ContentTable.TABLE_NAME, values);

        } catch (Exception e) {

        }
    }

}
