/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.NotificationApp;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;

public class NotiCatchDialogFragment
extends DialogFragment {
    public static final String TAG = NotiCatchDialogFragment.class.getSimpleName();
    public static final String ARG_TITLE = "ARG_TITLE";
    private AppAdapter appAdapter;
    private RecyclerView recyclerView;
    private VisualRepository repository;
    private Callback callback;
    private String title;

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public static NotiCatchDialogFragment newInstance(String title) {
        NotiCatchDialogFragment fragment = new NotiCatchDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_TITLE, title);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.title = bundle.getString(ARG_TITLE);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this.getActivity(), 16973931));
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.visual_dialog_noti_catch, null);
            TextView titleTextView = (TextView)view.findViewById(R.id.title);
            titleTextView.setText((CharSequence)this.getString(R.string.visual_notification_catch_dialog_title, new Object[]{Utils.getApplicationName(this.getActivity().getApplicationContext())}));
            if (!TextUtils.isEmpty((CharSequence)this.title)) {
                titleTextView.setText((CharSequence)this.title);
            }
            this.repository = RepositoryHolder.getInstance((Context)this.getActivity()).getVisualRepository();
            AlertDialog dialog = builder.create();
            dialog.setView(view, 0, 0, 0, 0);
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
            this.appAdapter = new AppAdapter(Glide.with((Activity)this.getActivity()));
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.appAdapter);
            new LoadTask().execute(new Void[0]);
            Button nextButton = (Button)view.findViewById(R.id.next);
            nextButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NotiCatchDialogFragment.this.callback != null) {
                        NotiCatchDialogFragment.this.callback.onClickNext();
                    }
                    NotiCatchDialogFragment.this.dismissAllowingStateLoss();
                }
            });
            return dialog;
        }
        catch (Exception e) {
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
    }

    public static class AppAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        ArrayList<NotificationApp> apps = new ArrayList();
        private final RequestManager requestManager;

        AppAdapter(RequestManager requestManager) {
            this.requestManager = requestManager;
        }

        void addAll(ArrayList<NotificationApp> smsList) {
            this.apps = smsList;
            this.notifyDataSetChanged();
        }

        public NotiCatchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.visual_item_noti, parent, false);
            return new NotiCatchViewHolder(v);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            NotificationApp notiCatch = this.apps.get(position);
            NotiCatchViewHolder notiCatchViewHolder = (NotiCatchViewHolder)holder;
            this.requestManager.load(notiCatch.getImage()).into(notiCatchViewHolder.icon);
            notiCatchViewHolder.appName.setText((CharSequence)notiCatch.getName());
        }

        public int getItemCount() {
            return this.apps == null ? 0 : this.apps.size();
        }

        static class NotiCatchViewHolder
        extends RecyclerView.ViewHolder {
            private ImageView icon;
            private TextView appName;

            NotiCatchViewHolder(View itemView) {
                super(itemView);
                this.icon = (ImageView)itemView.findViewById(R.id.icon);
                this.appName = (TextView)itemView.findViewById(R.id.app_name);
            }
        }
    }

    class LoadTask
    extends AsyncTask<Void, Void, ArrayList<NotificationApp>> {
        LoadTask() {
        }

        protected ArrayList<NotificationApp> doInBackground(Void ... voids) {
            return NotiCatchDialogFragment.this.repository.loadNotiCatchedApps();
        }

        protected void onPostExecute(ArrayList<NotificationApp> notiCatches) {
            super.onPostExecute(notiCatches);
            NotiCatchDialogFragment.this.appAdapter.addAll(notiCatches);
        }
    }

    public static interface Callback {
        public void onClickNext();
    }
}

