/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.util.SparseArray;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import java.util.ArrayList;

public class ContentsDao {
    private final Db db;

    public ContentsDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Content> loadContents() {
        String query = QueryGenerator.contents();
        ArrayList<Content> results = new ArrayList<Content>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.ContentTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseArray<ArrayList<Condition>> loadConditions() {
        String query = QueryGenerator.conditions();
        SparseArray results = new SparseArray();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    Condition condition = ReaderContract.ConditionTable.populateModel(c);
                    ArrayList<Condition> conditions = (ArrayList<Condition>)results.get(condition.getcId());
                    if (conditions == null) {
                        conditions = new ArrayList<Condition>();
                        conditions.add(condition);
                    } else {
                        conditions.add(condition);
                    }
                    results.put(condition.getcId(), conditions);
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void deleteContent(int cId) {
        this.db.delete(" CONTENTS", "contentId= " + cId, null);
        this.db.delete(" CONDITIONS", "cId= " + cId, null);
    }

    public void mergeContent(AnalysisResponse.Content content) {
        try {
            ContentValues values = new ContentValues();
            values.put("contentId", Integer.valueOf(content.getId()));
            values.put("priority", Integer.valueOf(content.getPriority()));
            values.put("categoryPriority", Integer.valueOf(content.getCategoryPriority()));
            values.put("numOfOccurrence", Integer.valueOf(content.getNumOfOccurence()));
            values.put("lCode", Integer.valueOf(content.getlCode()));
            values.put("rawKeys", content.getRawKeys());
            values.put("linkTo", content.getLinkTo());
            values.put("label", content.getLabel());
            values.put("largeContent", content.getlContent().replace("\n", "\\n"));
            values.put("largeKeys", content.getlKeys());
            values.put("mediumContent", content.getmContent().replace("\n", "\\n"));
            values.put("mediumKeys", content.getmKeys());
            values.put("image", content.getImage().replace("\n", "\\n"));
            this.db.insertOnReplace(" CONTENTS", values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteCondition(int id2) {
        try {
            this.db.delete(" CONDITIONS", "conditionId= ?", new String[]{id2 + ""});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mergeCondition(AnalysisResponse.Condition condition) {
        try {
            ContentValues values = new ContentValues();
            values.put("conditionId", Integer.valueOf(condition.getId()));
            values.put("standard", condition.getStandard());
            values.put("funcType", condition.getFuncType());
            values.put("funcKeys", condition.getFuncKeys());
            this.db.insertOnReplace(" CONTENTS", values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

