/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db;

import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.Content;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.entity.UserCategory;
import com.tenqube.visual_third.entity.VisualNotification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import tenqube.parser.constants.Constants;
import tenqube.parser.util.LogUtil;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static DatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = "visual.db";
    private static final int DATABASE_VERSION = 2;
    private static final String TAG = LogUtil.makeLogTag(DatabaseHelper.class);
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseHelper getInstance(Context context) {
        Class<DatabaseHelper> clazz = DatabaseHelper.class;
        synchronized (DatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new DatabaseHelper(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
        this.mContext = context;
    }

    public void onCreate(SQLiteDatabase db) throws SQLiteException {
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CARDS (cId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , changeName TEXT  NOT NULL  DEFAULT  'none'  , changeType INTEGER  NOT NULL  DEFAULT  0  , changeSubType INTEGER  NOT NULL  DEFAULT  0  , billingDay INTEGER  NOT NULL  DEFAULT  1  , balance REAL  NOT NULL  DEFAULT  0  , cardMemo TEXT  NOT NULL  DEFAULT  'none'  , isCardExcept INTEGER  NOT NULL  DEFAULT  0  , isCardCustom INTEGER  NOT NULL  DEFAULT  0  , isCardDeleted INTEGER  NOT NULL  DEFAULT  0  ,  UNIQUE (cardName , cardType , cardSubType) ON CONFLICT REPLACE )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  USER_CATEGORIES  (ucId INTEGER  PRIMARY KEY  AUTOINCREMENT  , repCode INTEGER  NOT NULL  DEFAULT  0  , isCateExcept INTEGER  NOT NULL  DEFAULT  0  , isCateMain INTEGER  NOT NULL  DEFAULT  0  )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CATEGORIES  (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cateCode INTEGER  NOT NULL  DEFAULT  0  , largeName TEXT  NOT NULL  DEFAULT  'none'  , mediumName TEXT  NOT NULL  DEFAULT  'none'  , smallName TEXT  NOT NULL  DEFAULT  'none'  )");
        db.execSQL(" CREATE TABLE  TRANSACTIONS (tranId INTEGER  PRIMARY KEY  AUTOINCREMENT  , identifier REAL  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , userCategoryId INTEGER  NOT NULL  DEFAULT  0  , companyId INTEGER  NOT NULL  DEFAULT  0  , franchise TEXT  NOT NULL  DEFAULT  'none'  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , oriSpentMoney REAL  NOT NULL  DEFAULT  0  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , keyword TEXT  NOT NULL  DEFAULT  'none'  , searchKeyword TEXT  NOT NULL  DEFAULT  'none'  , repeatType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isDeleted INTEGER  NOT NULL  DEFAULT  0  , dwType INTEGER  NOT NULL  DEFAULT  0  , sender TEXT  NOT NULL  DEFAULT  'none'  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , smsDate DATETIME  NOT NULL  DEFAULT  0  , smsType INTEGER  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isCustom INTEGER  NOT NULL  DEFAULT  0  , isUserUpdate INTEGER  NOT NULL  DEFAULT  0  , isUpdateAll INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , classCode TEXT  NOT NULL  DEFAULT  'none'  , isSynced INTEGER  NOT NULL  DEFAULT  0  , shouldRetrySearch INTEGER  NOT NULL  DEFAULT  0 )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CONTENTS (contentId INTEGER  PRIMARY KEY  AUTOINCREMENT  , priority INTEGER  NOT NULL  DEFAULT  0  , categoryPriority INTEGER  NOT NULL  DEFAULT  0  , numOfOccurrence INTEGER  NOT NULL  DEFAULT  0  , lCode INTEGER  NOT NULL  DEFAULT  0  , rawKeys TEXT  NOT NULL  DEFAULT  0  , linkTo TEXT  NOT NULL  DEFAULT  0  , label TEXT  NOT NULL  DEFAULT  'none'  , largeContent TEXT  NOT NULL  DEFAULT  'none'  , largeKeys TEXT  NOT NULL  DEFAULT  'none'  , mediumContent TEXT  NOT NULL  DEFAULT  'none'  , mediumKeys TEXT  NOT NULL  DEFAULT  'none'  , image TEXT  NOT NULL  DEFAULT  'none'  )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CONDITIONS (conditionId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cId INTEGER  NOT NULL  DEFAULT  0  , standard TEXT  NOT NULL  DEFAULT  0  , funcType TEXT  NOT NULL  DEFAULT  0  , funcKeys TEXT  NOT NULL  DEFAULT  'none'  )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  CURRENCY  (currency_id_pk INTEGER  PRIMARY KEY  , currency_from TEXT  NOT NULL  DEFAULT  'none'  , currency_to TEXT  NOT NULL  DEFAULT  'none'  , currency_rate REAL  NOT NULL  DEFAULT  0  , currency_created_at DATETIME  NOT NULL  DEFAULT  current_timestamp  ,  UNIQUE (currency_from , currency_to) )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  NOTIFICATIONS  (noti_id_pk INTEGER  PRIMARY KEY  , noti_name TEXT  NOT NULL  DEFAULT  'none'  , noti_title TEXT  NOT NULL  DEFAULT  'none'  , noti_content TEXT  NOT NULL  DEFAULT  'none'  , noti_ticker TEXT  NOT NULL  DEFAULT  'none'  , noti_alarm_type INTEGER  NOT NULL  DEFAULT  0  , noti_day_of_week INTEGER  NOT NULL  DEFAULT  0  , noti_hour INTEGER  NOT NULL  DEFAULT  0  , noti_day INTEGER  NOT NULL  DEFAULT  0  , noti_enable INTEGER  NOT NULL  DEFAULT  1  , noti_created_at DATETIME  NOT NULL  DEFAULT  current_timestamp  ,  UNIQUE (noti_name) )");
        db.execSQL("CREATE INDEX visual_card_idx ON  CARDS (cardName,cardType,cardSubType)");
        db.execSQL("CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType)");
        db.execSQL("CREATE INDEX qlip_transaction_idx3 ON  TRANSACTIONS (tranId)");
        db.execSQL("CREATE INDEX visual_contents_idx ON  CONTENTS (lCode)");
        db.execSQL("CREATE INDEX visual_conditions_idx ON  CONDITIONS (cId)");
        this.insertCategories(db);
        this.insertUserCategories(db);
        this.insertContents(db);
        this.insertConditions(db);
        this.insertCurrency(db);
        this.insertCash(db);
        this.insertNotifications(db);
    }

    private void insertCash(SQLiteDatabase db) throws SQLiteException {
        ContentValues values = new ContentValues();
        values.put("cardName", "\ud604\uae08");
        values.put("changeName", "\ud604\uae08");
        values.put("cardType", Integer.valueOf(Constants.CardType.CASH.ordinal()));
        values.put("changeType", Integer.valueOf(Constants.CardType.CASH.ordinal()));
        values.put("cardSubType", Integer.valueOf(0));
        values.put("changeSubType", Integer.valueOf(0));
        values.put("billingDay", Integer.valueOf(1));
        db.insert(" CARDS", null, values);
    }

    private void insertCategories(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("categories.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Category category = new Category(Integer.parseInt(colums[0]), Integer.parseInt(colums[1]), colums[2], colums[3], colums[4]);
                    values.add(category.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO CATEGORIES (_id,cateCode,largeName,mediumName,smallName)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertUserCategories(SQLiteDatabase db) throws SQLiteException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(new UserCategory(1, 101010, false, false).getInsertValue());
        values.add(new UserCategory(2, 221010, false, false).getInsertValue());
        values.add(new UserCategory(3, 241010, false, false).getInsertValue());
        values.add(new UserCategory(4, 261010, false, false).getInsertValue());
        values.add(new UserCategory(5, 321010, false, false).getInsertValue());
        values.add(new UserCategory(6, 341010, false, false).getInsertValue());
        values.add(new UserCategory(7, 361010, false, false).getInsertValue());
        values.add(new UserCategory(8, 421010, false, false).getInsertValue());
        values.add(new UserCategory(9, 441010, false, false).getInsertValue());
        values.add(new UserCategory(10, 461010, false, false).getInsertValue());
        values.add(new UserCategory(11, 521010, false, false).getInsertValue());
        values.add(new UserCategory(12, 541010, false, false).getInsertValue());
        values.add(new UserCategory(13, 561010, false, false).getInsertValue());
        values.add(new UserCategory(14, 621010, false, false).getInsertValue());
        values.add(new UserCategory(15, 641010, false, false).getInsertValue());
        values.add(new UserCategory(16, 661010, false, false).getInsertValue());
        values.add(new UserCategory(17, 821010, false, false).getInsertValue());
        values.add(new UserCategory(18, 841010, false, false).getInsertValue());
        values.add(new UserCategory(19, 881010, true, false).getInsertValue());
        values.add(new UserCategory(20, 901010, false, false).getInsertValue());
        values.add(new UserCategory(21, 921010, false, false).getInsertValue());
        values.add(new UserCategory(22, 941010, false, false).getInsertValue());
        values.add(new UserCategory(23, 961010, false, false).getInsertValue());
        values.add(new UserCategory(24, 981010, true, false).getInsertValue());
        String insertQuery = "INSERT OR REPLACE INTO USER_CATEGORIES (ucId,repCode,isCateExcept,isCateMain)VALUES" + TextUtils.join((CharSequence)",", values);
        db.execSQL(insertQuery);
        values.clear();
    }

    private void insertContents(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("contents.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Content contents = new Content(Integer.parseInt(colums[0]), Integer.parseInt(colums[1]), Integer.parseInt(colums[2]), Integer.parseInt(colums[3]), Integer.parseInt(colums[4]), colums[5], colums[6], colums[7], colums[8], colums[9], colums[10], colums[11], colums[12]);
                    values.add(contents.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO CONTENTS(contentId,priority,categoryPriority,numOfOccurrence,lCode,rawKeys,linkTo,label,largeContent,largeKeys,mediumContent,mediumKeys,image)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertConditions(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("conditions.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Condition condition = new Condition(Integer.parseInt(colums[0]), Integer.parseInt(colums[1]), colums[2], colums[3], colums[4]);
                    values.add(condition.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO CONDITIONS(conditionId,cId,standard,funcType,funcKeys)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void insertCurrency(SQLiteDatabase db) {
        ArrayList<String> currencies = new ArrayList<String>();
        AssetManager am = this.mContext.getAssets();
        try {
            InputStream inStream = am.open("currency.tsv");
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i = 0;
            while ((line = buffer.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                String[] colums = line.split("\t");
                currencies.add(new Currency(0, colums[0], colums[1], Double.parseDouble(colums[2]), colums[3]).insertValues());
                if (currencies.size() != 50) continue;
                String insertQuery = "INSERT OR REPLACE INTO CURRENCY (currency_from,currency_to,currency_rate,currency_created_at)VALUES" + TextUtils.join((CharSequence)",", currencies);
                db.execSQL(insertQuery);
                currencies.clear();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (buffer != null) {
                buffer.close();
            }
            if (currencies.size() != 0) {
                String insertQuery = "INSERT OR REPLACE INTO CURRENCY (currency_from,currency_to,currency_rate,currency_created_at)VALUES" + TextUtils.join((CharSequence)",", currencies);
                db.execSQL(insertQuery);
                currencies.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public void insertNotifications(SQLiteDatabase db) {
        ArrayList<String> notifications = new ArrayList<String>();
        AssetManager am = this.mContext.getAssets();
        try {
            InputStream inStream = am.open("notifications.tsv");
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
            String line = "";
            int i = 0;
            while ((line = buffer.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                String[] colums = line.split("\t");
                notifications.add(new VisualNotification(Integer.parseInt(colums[0]), colums[1], colums[2], colums[3], colums[4], Integer.parseInt(colums[5]), Integer.parseInt(colums[6]), Integer.parseInt(colums[7]), Integer.parseInt(colums[8]), Integer.parseInt(colums[10]) == 1, colums[11]).insertValues());
                if (notifications.size() != 50) continue;
                String insertQuery = "INSERT OR REPLACE INTO NOTIFICATIONS (noti_id_pk,noti_name,noti_title,noti_content,noti_ticker,noti_alarm_type,noti_day_of_week,noti_hour,noti_day,noti_enable,noti_created_at)VALUES" + TextUtils.join((CharSequence)",", notifications);
                db.execSQL(insertQuery);
                notifications.clear();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (buffer != null) {
                buffer.close();
            }
            if (notifications.size() != 0) {
                String insertQuery = "INSERT OR REPLACE INTO NOTIFICATIONS (noti_id_pk,noti_name,noti_title,noti_content,noti_ticker,noti_alarm_type,noti_day_of_week,noti_hour,noti_day,noti_enable,noti_created_at)VALUES" + TextUtils.join((CharSequence)",", notifications);
                db.execSQL(insertQuery);
                notifications.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) throws SQLiteException {
        if (newVersion > oldVersion) {
            switch (oldVersion) {
                case 1: {
                    db.execSQL(" DROP TABLE IF EXISTS  CONTENTS");
                    db.execSQL(" CREATE TABLE IF NOT EXISTS  CONTENTS (contentId INTEGER  PRIMARY KEY  AUTOINCREMENT  , priority INTEGER  NOT NULL  DEFAULT  0  , categoryPriority INTEGER  NOT NULL  DEFAULT  0  , numOfOccurrence INTEGER  NOT NULL  DEFAULT  0  , lCode INTEGER  NOT NULL  DEFAULT  0  , rawKeys TEXT  NOT NULL  DEFAULT  0  , linkTo TEXT  NOT NULL  DEFAULT  0  , label TEXT  NOT NULL  DEFAULT  'none'  , largeContent TEXT  NOT NULL  DEFAULT  'none'  , largeKeys TEXT  NOT NULL  DEFAULT  'none'  , mediumContent TEXT  NOT NULL  DEFAULT  'none'  , mediumKeys TEXT  NOT NULL  DEFAULT  'none'  , image TEXT  NOT NULL  DEFAULT  'none'  )");
                    this.insertContents(db);
                    db.execSQL(" DROP TABLE IF EXISTS  CONDITIONS");
                    db.execSQL(" CREATE TABLE IF NOT EXISTS  CONDITIONS (conditionId INTEGER  PRIMARY KEY  AUTOINCREMENT  , cId INTEGER  NOT NULL  DEFAULT  0  , standard TEXT  NOT NULL  DEFAULT  0  , funcType TEXT  NOT NULL  DEFAULT  0  , funcKeys TEXT  NOT NULL  DEFAULT  'none'  )");
                    this.insertConditions(db);
                    db.execSQL(" CREATE TABLE IF NOT EXISTS  NOTIFICATIONS  (noti_id_pk INTEGER  PRIMARY KEY  , noti_name TEXT  NOT NULL  DEFAULT  'none'  , noti_title TEXT  NOT NULL  DEFAULT  'none'  , noti_content TEXT  NOT NULL  DEFAULT  'none'  , noti_ticker TEXT  NOT NULL  DEFAULT  'none'  , noti_alarm_type INTEGER  NOT NULL  DEFAULT  0  , noti_day_of_week INTEGER  NOT NULL  DEFAULT  0  , noti_hour INTEGER  NOT NULL  DEFAULT  0  , noti_day INTEGER  NOT NULL  DEFAULT  0  , noti_enable INTEGER  NOT NULL  DEFAULT  1  , noti_created_at DATETIME  NOT NULL  DEFAULT  current_timestamp  ,  UNIQUE (noti_name) )");
                    this.insertNotifications(db);
                }
            }
        }
    }
}

