/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.api;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.ArrayList;

public class SearchCompanyResponse
implements Serializable {
    private ArrayList<TranCompany> results;

    public SearchCompanyResponse(ArrayList<TranCompany> results) {
        this.results = results;
    }

    public ArrayList<TranCompany> getResults() {
        return this.results;
    }

    public String toString() {
        return "SearchCompanyResponse{results=" + this.results + '}';
    }

    public static class Keyword
    implements Serializable {
        private String ori;
        private String search;

        public Keyword(String ori, String search) {
            this.ori = ori;
            this.search = search;
        }

        public String getOri() {
            return this.ori;
        }

        public String getSearch() {
            return this.search;
        }
    }

    public static class Category
    implements Serializable {
        private String code;

        public Category(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getRepCode() {
            return this.code.substring(0, 2) + "1010";
        }

        public String getLargeCode() {
            return this.code.substring(0, 2) + "";
        }

        public String toString() {
            return "Category{code='" + this.code + '\'' + '}';
        }
    }

    public static class Company
    implements Serializable {
        private int id;
        private String name;
        private String address;

        public Company(int id2, String name, String address) {
            this.id = id2;
            this.name = name;
            this.address = address;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String toString() {
            return "Company{id=" + this.id + ", name='" + this.name + '\'' + ", address='" + this.address + '\'' + '}';
        }
    }

    public static class TranCompany
    implements Serializable {
        @SerializedName(value="id")
        private String identifier;
        @SerializedName(value="classCode")
        private String classCode;
        @SerializedName(value="company")
        private Company company;
        @SerializedName(value="category")
        private Category category;
        @SerializedName(value="keyword")
        private Keyword keyword;
        private boolean isPopUpCompanyName;

        public TranCompany(String identifier, String classCode, Company company, Category category, Keyword keyword) {
            this.identifier = identifier;
            this.classCode = classCode;
            this.company = company;
            this.category = category;
            this.keyword = keyword;
        }

        public String toString() {
            return "TranCompany{identifier='" + this.identifier + '\'' + ", classCode='" + this.classCode + '\'' + ", company=" + this.company + ", category=" + this.category + ", keyword=" + this.keyword + ", isPopUpCompanyName=" + this.isPopUpCompanyName + '}';
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getClassCode() {
            return this.classCode;
        }

        public Company getCompany() {
            return this.company;
        }

        public Category getCategory() {
            return this.category;
        }

        public Keyword getKeyword() {
            return this.keyword;
        }

        public boolean isPopUpCompanyName() {
            return this.isPopUpCompanyName;
        }
    }
}

