package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.TransactionPopupInfo;

/**
 * 서버에서 전달받은 Transaction 객체를 가지고 팝업을 띄운다.
 * 1. intent Transaction객체
 * 2. validation 체크
 * 3. UI 구성
 */
public class TransactionPopupActivity extends Activity {

    public static final String ARG_TRANSACTION = "ARG_TRANSACTION";
    public static final String ACTION_TRANSACTION_RECEIVED = "tenqube.intent.action.ACTION_TRANSACTION_RECEIVED";
    public static final String ACTION_GO_DETAIL_CLICKED = "tenqube.intent.action.ACTION_GO_DETAIL_CLICKED";


    public static void startActivity(Context context, TransactionPopupInfo transactionPopupInfo) {
        Intent intent = new Intent(context, TransactionPopupActivity.class);
        intent.putExtra(ARG_TRANSACTION, transactionPopupInfo);
        context.startActivity(intent);
    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            overridePendingTransition(0, 0);

            requestWindowFeature(Window.FEATURE_NO_TITLE);
            getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            setContentView(R.layout.activity_transaction_popup);

            DisplayMetrics dm = new DisplayMetrics();
            getWindowManager().getDefaultDisplay().getMetrics(dm);

            TransactionPopupInfo transactionPopupInfo = (TransactionPopupInfo) getIntent().getSerializableExtra(ARG_TRANSACTION);
            if(transactionPopupInfo == null) {
                finish();
                return;
            }

            // 팝업 뜨는경우 브로드캐스트 해주기
            TextView companyTitleTextView = findViewById(R.id.company_title);
            companyTitleTextView.setText(transactionPopupInfo.getCompanyTitle());

            TextView companyAddressTextView = findViewById(R.id.company_address);
            companyAddressTextView.setText(transactionPopupInfo.getCompanyAddress());

            TextView spentDateTextView = findViewById(R.id.spent_date);
            spentDateTextView.setText(transactionPopupInfo.getSpentDate());

            TextView paymentTextView = findViewById(R.id.payment);
            paymentTextView.setText(transactionPopupInfo.getPayment());

            TextView installmentTextView = findViewById(R.id.installment);
            installmentTextView.setText(transactionPopupInfo.getInstallmentStr());

            TextView spentMoneyTextView = findViewById(R.id.spent_money);
            spentMoneyTextView.setText(transactionPopupInfo.getSpentMoneyStr());

            findViewById(R.id.go_detail).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    // 상세보기 페이지 이동
                    LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(new Intent(ACTION_GO_DETAIL_CLICKED));
                    finish();
                }
            });
            findViewById(R.id.close).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    finish();
                }
            });

            LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(new Intent(ACTION_TRANSACTION_RECEIVED));

        } catch (Exception e) {
            e.printStackTrace();
        }




    }


    @Override
    protected void onPause() {
        overridePendingTransition(0, 0);
        super.onPause();
    }
}
