/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationServices;

public class FusedLocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private GoogleApiClient mGoogleApiClient;
    private Context mContext;
    private Location mLocation = null;
    private static FusedLocationManager mInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FusedLocationManager getInstance(Context ctx) {
        Class<FusedLocationManager> clazz = FusedLocationManager.class;
        synchronized (FusedLocationManager.class) {
            if (mInstance == null) {
                mInstance = new FusedLocationManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private FusedLocationManager(Context context) {
        this.mContext = context;
    }

    public synchronized void buildGoogleApiClient() {
        try {
            this.mGoogleApiClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return;
            }
            this.mLocation = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onConnectionSuspended(int i) {
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.connect();
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public void onLocationChanged(Location location) {
        this.mLocation = location;
    }

    public void onStart() {
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.connect();
        }
    }

    public void onStop() {
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.disconnect();
        }
    }
}

