package com.tenqube.visual_third.parser.catcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsMessage;
import android.text.TextUtils;

import com.tenqube.visual_third.manager.PrefManager;

import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

import static com.tenqube.visual_third.util.Utils.getConvertedDate;

public class SMSCatcher extends BroadcastReceiver {

    private String TAG = SMSCatcher.class.getSimpleName();

    private static final String SMS_RECEIVED_ACTION = "android.provider.Telephony.SMS_RECEIVED";
    public SMSCatcher() {

    }

    @Override
    public void onReceive(final Context context, final Intent intent) {

        try {

            if(TextUtils.isEmpty(PrefManager.getInstance(context).loadStringValue(PrefManager.UID, "")))
                return;

            if (SMS_RECEIVED_ACTION.equals(intent.getAction())) {
                SMS sms = parseSms(intent.getExtras());
                if(sms != null)
                    sendIntentService(context, sms);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SMS parseSms(Bundle bundle) {

        if (bundle != null) {
            String originMsg = "";
            String displayMsg = "";

            String originTel = "";
            String displayTel = "";

            long date = 0;
            SmsMessage currentMessage;


            final Object[] pdusObj = (Object[]) bundle.get("pdus");

            if(pdusObj != null) {

                for (Object obj: pdusObj) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        String format = bundle.getString("format");
                        currentMessage = SmsMessage.createFromPdu((byte[])obj, format);
                    } else {
                        currentMessage = SmsMessage.createFromPdu((byte[]) obj);
                    }

                    if(currentMessage != null) {
                        if (currentMessage.getDisplayOriginatingAddress() != null)
                            displayTel = currentMessage.getDisplayOriginatingAddress();


                        if (currentMessage.getOriginatingAddress() != null)
                            originTel = currentMessage.getOriginatingAddress();


                        if (currentMessage.getTimestampMillis() != 0)
                            date = currentMessage.getTimestampMillis();

                        if(currentMessage.getMessageBody() != null)
                            originMsg += currentMessage.getMessageBody();


                        if (currentMessage.getDisplayMessageBody() != null)
                            displayMsg += currentMessage.getDisplayMessageBody();

                    }
                }

                if((displayTel != null || originTel != null) &&
                        (!TextUtils.isEmpty(displayTel)||!TextUtils.isEmpty(originTel)) &&
                        (!TextUtils.isEmpty(displayMsg)||!TextUtils.isEmpty(originMsg))) {

                    String fullSms = selectMsg(originMsg, displayMsg);
                    return new SMS(0, fullSms, originTel, displayTel, getConvertedDate(date), Constants.SMSType.SMS.ordinal());
                }
            } // pdusObj is null
        } // bundle is null

        return null;
    }

    private void sendIntentService(Context context, SMS sms) {
        Intent startIntent = new Intent(context, SmsMmsService.class);
        startIntent.putExtra(SmsMmsService.ARG_SMS, sms);
        context.startService(startIntent);
    }

    private String selectMsg(String originMsg, String displayMsg){

        String msg;

        if(TextUtils.isEmpty(originMsg)) {
            return displayMsg;
        }

        if(TextUtils.isEmpty(displayMsg)) {
            return originMsg;
        }

        if(originMsg.equals(displayMsg)) {
            msg = originMsg;
        } else {
            msg = displayMsg;
        }
        return  msg;
    }
}