/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.Request;
import com.tenqube.visual_third.util.Validator;
import java.io.Serializable;

public class UpdateTransactionRequest
extends Request
implements Serializable {
    private int id;
    private int lCode;
    private int mCode;
    private int cateConfigId;
    private String keyword;
    private double amount;
    private int cardId;
    private int installmentCnt;
    private String date;
    private String memo;
    private boolean isExpense;
    private boolean isAll;
    private String callbackJS;

    public int getTranId() {
        return this.id;
    }

    public int getlCode() {
        return this.lCode;
    }

    public int getmCode() {
        return this.mCode;
    }

    public int getCateConfigId() {
        return this.cateConfigId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public double getAmount() {
        return this.amount;
    }

    public int getCardId() {
        return this.cardId;
    }

    public int getInstallmentCnt() {
        return this.installmentCnt == 0 ? 1 : this.installmentCnt;
    }

    public String getDate() {
        return this.date;
    }

    public String getMemo() {
        return this.memo;
    }

    public boolean isExpense() {
        return this.isExpense;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public String getCallbackJS() {
        return this.callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        Validator.notZero(this.id);
        Validator.notZero(this.cardId);
        Validator.notZero(this.cateConfigId);
        Validator.len("" + this.lCode, 2);
        Validator.len("" + this.mCode, 2);
        Validator.isStr(this.keyword, 50);
        Validator.gt(this.installmentCnt, 0);
        Validator.lt(this.installmentCnt, 25);
        Validator.isDate(this.date);
        Validator.isStr(this.memo, 300);
        Validator.isStr(this.callbackJS, 30);
    }
}

