/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.SyncListener;
import com.tenqube.visual_third.SyncService;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.SyncData;
import com.tenqube.visual_third.model.parser.SyncTransaction;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.parser.SyncHolder;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public class BulkLoader
extends BaseLoader
implements BulkSmsAdapter {
    private static final String TAG = BulkLoader.class.getSimpleName();
    private static final int BULK_MONTH = -3;
    private Cursor mCursor;
    private final Handler mHandler;
    private final OnSmsLoadFinished onSmsLoadFinished;
    private long fromSmsDate;

    public BulkLoader(Context context, Handler handler, OnSmsLoadFinished onSmsLoadFinished) {
        super(context);
        this.mHandler = handler;
        this.onSmsLoadFinished = onSmsLoadFinished;
    }

    public void doParsing(final boolean isInit) {
        this.syncParsingRule(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                BulkLoader.this.sync(new Callback<Boolean>(){

                    @Override
                    public void onDataLoaded(@Nullable Boolean success) {
                        BulkLoader.this.prefManager.saveStringValue("TENQUBE_RESTORE_STATUS", success == null ? "none" : (success != false ? "success" : "fail"));
                        if (success != null && !success.booleanValue()) {
                            if (isInit) {
                                BulkLoader.this.sendHandlerMsg(null, 14, 0);
                            } else {
                                BulkLoader.this.sendHandlerMsg(null, 13, 0);
                            }
                        } else {
                            if (isInit) {
                                BulkLoader.this.mHandler.sendEmptyMessage(12);
                                BulkLoader.this.mHandler.sendEmptyMessage(17);
                            }
                            BulkLoader.this.initCursor();
                            BulkLoader.this.parserService.parseBulk((BulkSmsAdapter)BulkLoader.this);
                        }
                    }
                });
            }
        });
    }

    private void sync(final Callback<Boolean> callback) {
        final SyncService syncService = SyncHolder.getInstance().getSyncService();
        if (syncService != null) {
            syncService.getSyncData(new SyncListener(){

                @Override
                public void onSuccess(SyncData syncData) {
                    try {
                        if (syncData != null && !syncData.getTransactions().isEmpty()) {
                            BulkLoader.this.fromSmsDate = BulkLoader.this.getLastSmsDate(syncData.getTransactions());
                            List<SyncTransaction> transactions = syncData.getTransactions();
                            int total = transactions.size();
                            int i = 0;
                            for (SyncTransaction tran : transactions) {
                                int percent = i * 10 / total + 1;
                                BulkLoader.this.sendHandlerMsg(null, 15, percent);
                                BulkLoader.this.repository.insertTransaction(tran);
                                ++i;
                            }
                            BulkLoader.this.onResult(syncService, true);
                            callback.onDataLoaded(true);
                        } else {
                            BulkLoader.this.onResult(syncService, true);
                            callback.onDataLoaded(null);
                        }
                    }
                    catch (Exception e) {
                        BulkLoader.this.onResult(syncService, false);
                        callback.onDataLoaded(false);
                    }
                }

                @Override
                public void onError() {
                    BulkLoader.this.onResult(syncService, false);
                    callback.onDataLoaded(false);
                }
            });
        } else {
            callback.onDataLoaded(true);
        }
    }

    private void onResult(final SyncService syncService, final boolean isSuccess) {
        new Handler(this.mContext.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                syncService.onResult(isSuccess);
            }
        });
    }

    private long getLastSmsDate(List<SyncTransaction> transactions) {
        long maxTime = 0L;
        long today = new Date().getTime();
        for (SyncTransaction tran : transactions) {
            long time = Utils.toTime(tran.spentDate);
            if (time > today || time <= maxTime) continue;
            maxTime = time;
        }
        return maxTime;
    }

    private long getToSmsDate() {
        return this.prefManager.loadLongValue("TENQUBE_FIRST_SMS_DATE", this.prefManager.loadLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis()));
    }

    private void initCursor() {
        try {
            Uri uri = Uri.parse((String)"content://sms/inbox");
            this.mCursor = this.mContext.getContentResolver().query(uri, null, this.getWhere(), null, "date asc");
            if (this.mCursor != null) {
                this.mCursor.moveToFirst();
            }
        }
        catch (Exception e) {
            this.onError(1);
        }
    }

    private long getFromTime(long toTime) {
        if (this.fromSmsDate != 0L) {
            return this.fromSmsDate;
        }
        return 0L;
    }

    private String getWhere() {
        long toTime = this.getToSmsDate();
        long fromTime = this.getFromTime(toTime);
        Utils.LOGD(TAG, "BulkTime fromDate: " + Utils.getConvertedDate(fromTime));
        Utils.LOGD(TAG, "BulkTime toDate: " + Utils.getConvertedDate(toTime));
        return "date > " + fromTime + " and date < " + toTime;
    }

    public int getSmsCount() {
        return this.mCursor == null ? 0 : this.mCursor.getCount();
    }

    public SMS getSmsAt(int n) {
        return this.getSMS();
    }

    private SMS getSMS() {
        SMS sms = null;
        if (this.mCursor != null) {
            sms = new SMS(this.mCursor.getInt(this.mCursor.getColumnIndex("_id")), this.mCursor.getString(this.mCursor.getColumnIndex("body")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), Utils.getConvertedDate(this.mCursor.getLong(this.mCursor.getColumnIndex("date"))), Constants.SMSType.SMS.ordinal());
            this.mCursor.moveToNext();
        }
        return sms;
    }

    public void onProgress(int now, int total) {
        this.sendProgress(now, total);
    }

    private boolean hasSync() {
        return this.fromSmsDate != 0L;
    }

    private void sendProgress(int now, int total) {
        Bundle bundle = new Bundle();
        bundle.putInt("now", now);
        bundle.putInt("total", total);
        this.sendHandlerMsg(bundle, 11, 0);
    }

    public void sendToServerTransactions(ArrayList<tenqube.parser.model.Transaction> parsedTransactions, OnNetworkResultListener callback) {
        try {
            SearchCompanyResponse response;
            ArrayList subParsedTransactions = parsedTransactions.size() > 30 ? (ArrayList)parsedTransactions.subList(0, 30) : parsedTransactions;
            ArrayList<Transaction> transactions = Mapper.toParserTransactions(subParsedTransactions);
            this.setCurrency(transactions);
            this.repository.mergeTransactions(transactions);
            ArrayList<SearchCompanyRequest.Transaction> apiTransactions = Mapper.toSearchTransaction(transactions);
            if (!Utils.isEmpty(apiTransactions) && (response = this.repository.searchCompany(new SearchCompanyRequest(apiTransactions))) != null) {
                this.repository.updateTransactions(response);
            }
            this.repository.syncTransactions(callback);
        }
        catch (Exception e) {
            callback.onResult(true);
        }
    }

    public void onCompleted() {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(false);
        }
    }

    public void onError(int resultCode) {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(true);
        }
    }

    private void sendHandlerMsg(Bundle data, int what, int arg1) {
        if (this.mHandler != null) {
            Message hMsg = this.mHandler.obtainMessage();
            if (data != null) {
                hMsg.setData(data);
            }
            hMsg.what = what;
            hMsg.arg1 = arg1;
            this.mHandler.sendMessage(hMsg);
        }
    }

    public static interface OnSmsLoadFinished {
        public void onFinished(boolean var1);
    }
}

