/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.SyncService;
import com.tenqube.visual_third.VisualCallback;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.VisualSummary;
import com.tenqube.visual_third.VisualUserInfo;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.parser.SyncHolder;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import tenqube.parser.constants.Constants;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private AnalysisService service;
    private VisualCallback visualCallback;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private AppExecutors appExecutors = new AppExecutors();

    private VisualServiceImpl(Builder builder) throws ParameterException {
        Validator.notNull(builder.context);
        Validator.isNotEmpty(builder.apiKey);
        Validator.isNotEmpty(builder.authority);
        Validator.notZero(builder.smallIcon);
        Validator.notNull(builder.channel);
        Validator.in(builder.qualifier, "dev", "prod");
        this.context = builder.context;
        Constants.sLogger = builder.logger;
        this.visualCallback = builder.visualCallback;
        this.repository = RepositoryHolder.getInstance(this.context).getVisualRepository();
        this.repository.saveSDKInfo(builder.apiKey, builder.qualifier, builder.authority);
        this.repository.settingNotification(builder.smallIcon, builder.channel, builder.color);
        this.repository.setVisualCallback(this.visualCallback);
        this.alarmManager = VisualAlarmManager.getInstance(this.context);
        this.service = new AnalysisServiceImpl(this.context, builder.qualifier);
    }

    @Override
    public void startVisual(final @NonNull Activity activity, @NonNull String serviceId, @NonNull VisualUserInfo visualUserInfo, final @Nullable SyncService syncService, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.notNull(activity);
        Validator.isNotEmpty(serviceId);
        Validator.notNull(resultListener);
        Validator.notNull(visualUserInfo);
        Utils.LOGD("startVisual", "serviceId: " + serviceId);
        Utils.LOGD("startVisual", "visualUserInfo: " + visualUserInfo);
        this.repository.signUp(serviceId, visualUserInfo, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                try {
                    switch (signUpResult) {
                        case 0: 
                        case 3: {
                            SyncHolder.getInstance().setSyncService(syncService);
                            VisualWebActivity.startActivity(activity, "");
                            return;
                        }
                    }
                    return;
                }
                catch (AuthException e) {
                    signUpResult = 1;
                    msg = e.toString();
                    return;
                }
                finally {
                    resultListener.onResult(signUpResult, msg);
                }
            }
        });
    }

    @Override
    public void setVisualCallback(VisualCallback callback) {
        Utils.LOGD("setVisualCallback", "callback");
        this.repository.setVisualCallback(callback);
    }

    @Override
    public String getNotificationServiceName() {
        Utils.LOGD("getNotificationServiceName", "");
        return "com.tenqube.visual_third.parser.catcher.NotiCatcher";
    }

    @Override
    public void signOut(Callback<Boolean> callback) {
        Utils.LOGD("signOut", "");
        this.repository.signOut(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                VisualServiceImpl.this.alarmManager.setAlarms();
            }
        });
    }

    @Override
    public boolean isActiveTranPopup() {
        Utils.LOGD("isActiveTranPopup", "");
        return this.repository.isActiveTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        Utils.LOGD("setTranPopup", "isActive: " + isActive);
        this.repository.setTranPopup(isActive);
    }

    @Override
    public void setReportAlarm(Constants.ReportAlarmType type, boolean isActive) {
        Utils.LOGD("setReportAlarm", "ReportAlarmType: " + type.name());
        Utils.LOGD("setReportAlarm", "isActive: " + isActive);
        this.repository.setActiveNoti(type.name().toLowerCase(), isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveReportAlarm(Constants.ReportAlarmType type) {
        Utils.LOGD("isActiveReportAlarm", "type: " + type.name());
        return this.repository.isActiveNoti(type.name().toLowerCase());
    }

    @Override
    public void setReportTest(Constants.ReportAlarmType type, int second) {
        Utils.LOGD("setReportTest", "type: " + type.name());
        Utils.LOGD("setReportTest", "second: " + second);
        this.alarmManager.setReportTest(type.name().toLowerCase(), second);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Utils.LOGD("setEnabled", "enabled: " + enabled);
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setNotiAll(false);
            this.alarmManager.setAlarms();
        }
    }

    @Override
    public boolean isJoined() {
        Utils.LOGD("isJoined", "");
        return this.repository.isJoined();
    }

    @Override
    public void getVisualSummary(final Callback<VisualSummary> callback) {
        Utils.LOGD("getVisualSummary", "");
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                if (!VisualServiceImpl.this.repository.isJoined()) {
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(null);
                        }
                    });
                } else {
                    VisualSummary visualSummary;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, true, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = VisualServiceImpl.this.repository.loadAnalysisTransactions(request);
                    ArrayList<Analysis> monthly = VisualServiceImpl.this.service.loadAnalysisList(transactions, VisualServiceImpl.this.repository.getStartDay(), true);
                    double sum = VisualServiceImpl.this.getCurrentMonthSum(year, month);
                    Utils.LOGD("getVisualSummary", "sum: " + sum);
                    if (monthly.isEmpty()) {
                        visualSummary = new VisualSummary(sum, String.format("\uc774\ubc88 \ub2ec \uc9c0\ucd9c\uc740 %1$s \uc785\ub2c8\ub2e4.", AnalysisHelper.getLv0Currency(sum)));
                    } else {
                        Collections.shuffle(monthly);
                        Analysis analysis = monthly.get(0);
                        visualSummary = new VisualSummary(sum, analysis.getlContent());
                    }
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            Utils.LOGD("getVisualSummary", "visualSummary: " + visualSummary.toString());
                            callback.onDataLoaded(visualSummary);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void getSum(final long from, final long to, final Callback<VisualSummary> callback) {
        Utils.LOGD("getSum", "from: " + from);
        Utils.LOGD("getSum", "to: " + to);
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                if (!VisualServiceImpl.this.repository.isJoined()) {
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(null);
                        }
                    });
                } else {
                    final double amount = VisualServiceImpl.this.repository.getSum(Utils.getConvertedDate(from), Utils.getConvertedDate(to));
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            Utils.LOGD("getSum", "onDataLoaded: " + amount);
                            callback.onDataLoaded(new VisualSummary(amount, ""));
                        }
                    });
                }
            }
        });
    }

    private double getCurrentMonthSum(int year, int month) {
        TransactionRequest currentRequest = new TransactionRequest(year, month, 0, true, "");
        currentRequest.setDwType(Constants.DWType.WITHDRAW.ordinal());
        currentRequest.setExceptType(0);
        ArrayList<Transaction> currentMonthTransactions = this.repository.loadAnalysisTransactions(currentRequest);
        return Utils.sumBy(currentMonthTransactions);
    }

    @Override
    public void setAppNoti(boolean isActive) {
        Utils.LOGD("setAppNoti", "isActive: " + isActive);
        this.repository.setAppNoti(isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveAppNoti() {
        Utils.LOGD("isActiveAppNoti", "");
        return this.repository.isAppNoti();
    }

    public static class Builder {
        Context context;
        VisualCallback visualCallback;
        String apiKey;
        String qualifier;
        String authority;
        int smallIcon;
        String channel;
        int color;
        boolean logger;

        public Builder withContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder visualCallback(VisualCallback visualCallback) {
            this.visualCallback = visualCallback;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public Builder notification(int smallIcon, @NonNull String channel, int color2) {
            this.smallIcon = smallIcon;
            this.channel = channel;
            this.color = color2;
            return this;
        }

        public Builder logger(boolean logger) {
            this.logger = logger;
            return this;
        }

        public VisualService build() throws ParameterException {
            return new VisualServiceImpl(this);
        }
    }
}

