/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.worker;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.os.BuildCompat;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;

public class ReportWorker
extends Worker {
    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION_HANA";
    public static final String ARG_ACTION = "ARG_ACTION";
    public static final String ARG_NOTI_ID = "TENQUBE_ARG_NOTI_ID";
    public static final String ARG_NOTI_TEST = "TENQUBE_ARG_NOTI_TEST";
    private Context mContext;

    public ReportWorker(@NonNull Context context, @NonNull WorkerParameters params) {
        super(context, params);
        this.mContext = this.getContext(context);
    }

    public ListenableWorker.Result doWork() {
        Utils.LOGD("doWork", "start");
        if (ACTION_TENQUBE_NOTIFICATION.equals(this.getInputData().getString(ARG_ACTION))) {
            try {
                int notiId = this.getInputData().getInt(ARG_NOTI_ID, -1);
                boolean isTest = this.getInputData().getBoolean(ARG_NOTI_TEST, false);
                Utils.LOGD("doWork", "notiId:" + notiId);
                Utils.LOGD("doWork", "isTest:" + isTest);
                if (notiId != -1) {
                    VisualNotification notification = VisualAlarmManager.getInstance(this.mContext).getNotification(notiId);
                    Utils.LOGD("doWork", "isTest:" + isTest);
                    if (notification != null && notification.isEnable() && !"daily".equals(notification.getName())) {
                        if (isTest || this.shouldShow(notification)) {
                            VisualNotificationManager.getInstance(this.mContext).showNotification(notification);
                            if (isTest) {
                                VisualAlarmManager.getInstance(this.mContext).setReportTest(Constants.ReportAlarmType.MONTHLY.name().toLowerCase(), 10);
                            } else {
                                VisualAlarmManager.getInstance(this.mContext).setAlarm(notification);
                            }
                        }
                    } else {
                        Utils.LOGD("doWork", "notification: disabled");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ListenableWorker.Result.success();
    }

    private boolean shouldShow(VisualNotification notification) {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int diff = hour - notification.getHour();
        return Math.abs(diff) < 3;
    }

    private Context getContext(Context context) {
        if (BuildCompat.isAtLeastN()) {
            return context.createDeviceProtectedStorageContext();
        }
        return context;
    }
}

