/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.api;

import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import tenqube.parser.constants.Constants;

public class SearchCompanyRequest
implements Serializable {
    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return this.transactions;
    }

    public SearchCompanyRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction {
        @SerializedName(value="id")
        String identifier;
        @SerializedName(value="keyword")
        String keyword;
        @Expose
        String type;
        @Expose
        String at;
        @Expose
        String method;
        @Expose
        double amount;
        @Expose
        String amountType;
        @Expose
        double lat;
        @SerializedName(value="long")
        double lng;
        @Expose
        private Integer lCode;
        @Expose
        private Integer mCode;

        public String getIdentifier() {
            return this.identifier;
        }

        public Transaction(tenqube.parser.model.Transaction transaction) throws ParameterException {
            if (transaction == null) {
                throw new ParameterException("transaction is null");
            }
            this.setIdentifier(transaction.identifier);
            this.setKeyword(transaction.keyword);
            this.setType(transaction.dwType == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw");
            this.setAt(transaction.spentDate);
            this.setMethod(transaction.cardType == 0 ? "debit" : (transaction.cardType == 1 ? "credit" : "account"));
            this.setAmount(transaction.spentMoney);
            this.setAmountType(TextUtils.isEmpty((CharSequence)transaction.currency) || "none".equals(transaction.currency) ? "KRW" : transaction.currency);
            this.setLat(transaction.spentLatitude);
            this.setLng(transaction.spentLongitude);
        }

        public Transaction(JoinedTransaction transaction) throws ParameterException {
            if (transaction == null || transaction.getTransaction() == null) {
                throw new ParameterException("check transaction");
            }
            this.setIdentifier("" + transaction.getTransaction().getIdentifier());
            this.setKeyword(transaction.getTransaction().getKeyword());
            this.setType(transaction.getTransaction().getDwType() == Constants.DWType.DEPOSIT.ordinal() ? "deposit" : "withdraw");
            this.setAt(transaction.getTransaction().getSpentDate());
            this.setMethod(transaction.getCard().getType() == 0 ? "debit" : (transaction.getCard().getType() == 1 ? "credit" : "account"));
            this.setAmount(transaction.getTransaction().getSpentMoney());
            this.setAmountType(TextUtils.isEmpty((CharSequence)transaction.getTransaction().getCurrency()) || "none".equals(transaction.getTransaction().getCurrency()) ? "KRW" : transaction.getTransaction().getCurrency());
            this.setLat(transaction.getTransaction().getLat());
            this.setLng(transaction.getTransaction().getLng());
        }

        private void setIdentifier(String identifier) throws ParameterException {
            Validator.isStr(identifier, 50);
            this.identifier = identifier;
        }

        private void setKeyword(String keyword) throws ParameterException {
            keyword = TextUtils.isEmpty((CharSequence)keyword) ? "\ub0b4\uc6a9\uc5c6\uc74c" : keyword;
            Validator.isStr(keyword, 50);
            this.keyword = keyword;
        }

        private void setType(String type) throws ParameterException {
            Validator.in(type, "withdraw", "deposit");
            this.type = type;
        }

        private void setAt(String at) throws ParameterException {
            Validator.isDate(at);
            this.at = at;
        }

        private void setMethod(String method) throws ParameterException {
            Validator.in(method, "credit", "debit", "account");
            this.method = method;
        }

        private void setAmount(double amount) {
            this.amount = amount;
        }

        private void setAmountType(String amountType) throws ParameterException {
            Validator.isStr(amountType, 3);
            this.amountType = amountType;
        }

        private void setLat(double lat) {
            this.lat = lat == 0.0 ? -1.0 : lat;
        }

        private void setLng(double lng) {
            this.lng = lng == 0.0 ? -1.0 : lng;
        }

        public void setlCode(int lCode) {
            if (String.valueOf(lCode).length() == 2) {
                this.lCode = lCode;
            }
        }

        public void setmCode(int mCode) {
            if (String.valueOf(mCode).length() == 2) {
                this.mCode = mCode;
            }
        }
    }
}

