/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.repository;

import android.support.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.api.resource.ResourceService;
import com.tenqube.visual_third.db.dao.CategoryDao;
import com.tenqube.visual_third.db.dao.ContentsDao;
import com.tenqube.visual_third.db.dao.NotificationAppDao;
import com.tenqube.visual_third.db.dao.NotificationDao;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SignatureManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.VisualInjection;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;

public class ResourceRepository {
    @Nullable
    private ResourceService resourceService;
    private final PrefManager prefManager;
    private final ParserService parserService;
    private final AppExecutors appExecutors;
    private final NotificationAppDao notificationAppDao;
    private final CategoryDao categoryDao;
    private final NotificationDao notificationDao;
    private final ContentsDao contentsDao;
    private final SignatureManager signatureManager;
    private static ResourceRepository mInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceRepository getInstance(PrefManager prefManager, ParserService parserService, AppExecutors appExecutors, NotificationAppDao notificationAppDao, CategoryDao categoryDao, NotificationDao notificationDao, ContentsDao contentsDao, SignatureManager signatureManager) {
        Class<ResourceRepository> clazz = ResourceRepository.class;
        synchronized (ResourceRepository.class) {
            if (mInstance == null) {
                mInstance = new ResourceRepository(prefManager, parserService, appExecutors, notificationAppDao, categoryDao, notificationDao, contentsDao, signatureManager);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return mInstance;
        }
    }

    private ResourceRepository(PrefManager prefManager, ParserService parserService, AppExecutors appExecutors, NotificationAppDao notificationAppDao, CategoryDao categoryDao, NotificationDao notificationDao, ContentsDao contentsDao, SignatureManager signatureManager) {
        this.prefManager = prefManager;
        this.parserService = parserService;
        this.appExecutors = appExecutors;
        this.notificationAppDao = notificationAppDao;
        this.categoryDao = categoryDao;
        this.notificationDao = notificationDao;
        this.contentsDao = contentsDao;
        this.signatureManager = signatureManager;
    }

    private void createResource() {
        ResourceApi resourceApi = VisualInjection.provideResourceApi(this.prefManager);
        this.resourceService = VisualInjection.provideResourceService(resourceApi, this.signatureManager);
    }

    public void sync() {
        if (this.resourceService == null) {
            this.createResource();
        }
        this.appExecutors.networkIO().execute(new Runnable(){

            @Override
            public void run() {
                VersionResponse versionResponse = ResourceRepository.this.resourceService.syncVersion();
                if (versionResponse != null) {
                    ResourceRepository.this.syncCategory(versionResponse);
                    ResourceRepository.this.syncAnalysis(versionResponse);
                    ResourceRepository.this.syncNotification(versionResponse);
                    ResourceRepository.this.syncNotificationApps(versionResponse);
                    ResourceRepository.this.syncParsingRule(versionResponse);
                }
            }
        });
    }

    private void syncCategory(VersionResponse versionResponse) {
        SyncCategoryResponse response;
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_CATEGORY_VERSION", 11);
        if (versionResponse != null && versionResponse.getCategory() > clientVersion && this.resourceService != null && (response = this.resourceService.syncCategory(clientVersion, versionResponse.getCategory())) != null) {
            this.prefManager.saveIntValue("TENQUBE_CATEGORY_VERSION", versionResponse.getCategory());
            if (!response.getCategories().isEmpty()) {
                this.mergeCategory(response.getCategories());
            }
        }
    }

    private void mergeCategory(ArrayList<SyncCategoryResponse.Category> categories) {
        try {
            for (SyncCategoryResponse.Category category : categories) {
                this.categoryDao.mergeCategory(category);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncAnalysis(VersionResponse versionResponse) {
        AnalysisResponse response;
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_ANALYSIS_VERSION", 1);
        if (versionResponse != null && versionResponse.getAnalysis() > clientVersion && this.resourceService != null && (response = this.resourceService.syncAnalysis(clientVersion, versionResponse.getAnalysis())) != null) {
            this.prefManager.saveIntValue("TENQUBE_ANALYSIS_VERSION", versionResponse.getAnalysis());
            if (!Utils.isEmpty(response.getContents())) {
                this.mergeAnalysis(response.getContents());
            }
        }
    }

    private void mergeAnalysis(ArrayList<AnalysisResponse.Content> contents) {
        for (AnalysisResponse.Content content : contents) {
            if (content.getEnable() == 0) {
                this.contentsDao.deleteContent(content.getId());
                continue;
            }
            this.contentsDao.mergeContent(content);
            if (Utils.isEmpty(content.getConditions())) continue;
            for (AnalysisResponse.Condition condition : content.getConditions()) {
                if (condition.getEnable() == 0) {
                    this.contentsDao.deleteCondition(condition.getId());
                    continue;
                }
                this.contentsDao.mergeCondition(condition);
            }
        }
    }

    private void syncParsingRule(VersionResponse versionResponse) {
        ParsingRule parsingRule;
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", 214);
        if (versionResponse != null && versionResponse.getParsingRule() > clientVersion && this.resourceService != null && (parsingRule = this.resourceService.syncParsingRule(clientVersion, versionResponse.getParsingRule())) != null) {
            this.parserService.syncParsingRule(parsingRule);
            this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
        }
    }

    public void syncNotification() {
        if (this.resourceService == null) {
            this.createResource();
        }
        if (this.resourceService == null) {
            return;
        }
        this.appExecutors.networkIO().execute(new Runnable(){

            @Override
            public void run() {
                NotificationResponse response;
                VersionResponse versionResponse = ResourceRepository.this.resourceService.syncVersion();
                int clientVersion = ResourceRepository.this.prefManager.loadIntValue("TENQUBE_NOTIFICATION_VERSION", 1);
                if (versionResponse != null && versionResponse.getNotification() > clientVersion && (response = ResourceRepository.this.resourceService.syncNotification()) != null) {
                    ResourceRepository.this.prefManager.saveIntValue("TENQUBE_NOTIFICATION_VERSION", versionResponse.getNotification());
                    ResourceRepository.this.prefManager.saveIntValue("TENQUBE_NOTIFICATION_DIVIDER", response.getDivider());
                    if (response.getNotifications() != null && !response.getNotifications().isEmpty()) {
                        ResourceRepository.this.mergeNotifications(response.getNotifications());
                    }
                }
            }
        });
    }

    private void syncNotification(VersionResponse versionResponse) {
        NotificationResponse response;
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_NOTIFICATION_VERSION", 1);
        if (versionResponse != null && versionResponse.getNotification() > clientVersion && this.resourceService != null && (response = this.resourceService.syncNotification()) != null) {
            this.prefManager.saveIntValue("TENQUBE_NOTIFICATION_VERSION", versionResponse.getNotification());
            this.prefManager.saveIntValue("TENQUBE_NOTIFICATION_DIVIDER", response.getDivider());
            if (response.getNotifications() != null && !response.getNotifications().isEmpty()) {
                this.mergeNotifications(response.getNotifications());
            }
        }
    }

    private void mergeNotifications(ArrayList<NotificationResponse.Notification> notifications) {
        try {
            ArrayList<VisualNotification> values = new ArrayList<VisualNotification>();
            for (NotificationResponse.Notification notification : notifications) {
                values.add(notification.toVisualNotification());
            }
            if (!values.isEmpty()) {
                this.notificationDao.mergeNotifications(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncNotificationApps(VersionResponse versionResponse) {
        NotificationPkgResponse response;
        int clientVersion = this.prefManager.loadIntValue("TENQUBE_PKG_VERSION", 1);
        if (versionResponse != null && versionResponse.getPkgVersion() > clientVersion && this.resourceService != null && (response = this.resourceService.syncNotificationApps()) != null) {
            this.notificationAppDao.mergeAll(response.getApps());
            this.prefManager.saveIntValue("TENQUBE_PKG_VERSION", versionResponse.getPkgVersion());
        }
    }

    public ParsingRuleKey syncParsingRuleKey() {
        if (this.resourceService == null) {
            this.createResource();
        }
        if (this.resourceService == null) {
            return null;
        }
        return this.resourceService.syncParsingRuleKey();
    }

    public void syncParsingRule(final Callback<ParsingRule> callback) {
        if (this.resourceService == null) {
            this.createResource();
        }
        this.appExecutors.networkIO().execute(new Runnable(){

            @Override
            public void run() {
                VersionResponse versionResponse = ResourceRepository.this.resourceService.syncVersion();
                int clientVersion = ResourceRepository.this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", 214);
                ParsingRule parsingRule = null;
                if (versionResponse != null) {
                    parsingRule = ResourceRepository.this.resourceService.syncParsingRule(clientVersion, versionResponse.getParsingRule());
                }
                final ParsingRule finalParsingRule = parsingRule;
                ResourceRepository.this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onDataLoaded(finalParsingRule);
                    }
                });
            }
        });
    }
}

