/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualProgressDialogFragment
extends DialogFragment {
    public static final String TAG = VisualProgressDialogFragment.class.getSimpleName();
    private Context context;
    private ProgressBar progressBar;
    private TextView percentTextView;

    public static VisualProgressDialogFragment newInstance() {
        return new VisualProgressDialogFragment();
    }

    public void setProgressValue(int progress) {
        this.progressBar.setProgress(progress);
        this.percentTextView.setText((CharSequence)(progress + "%"));
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            LogUtil.LOGI((String)"VisualFlow", (String)"show bulk progress popup", (boolean)ParserService.mIsDebug);
            if (this.context == null) {
                this.context = this.getActivity();
            }
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, R.style.AlertDialogCustom));
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.visual_dialog_progress, null);
            this.progressBar = (ProgressBar)view.findViewById(R.id.visual_progress);
            this.percentTextView = (TextView)view.findViewById(R.id.visual_percent);
            builder.setView(view);
            AlertDialog dialog = builder.create();
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            return dialog;
        }
        catch (Exception e) {
            LogUtil.LOGI((String)"VisualFlow", (String)"show bulk progress popup", (boolean)ParserService.mIsDebug);
            e.printStackTrace();
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
    }
}

