/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualCallback;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.VisualSummary;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.AppExecutors;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.ParserService;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private AnalysisService service;
    private ParserService parserService;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;
    private AppExecutors appExecutors = new AppExecutors();

    public VisualServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @NonNull String authority) throws ParameterException {
        Validator.notNull(context);
        Validator.isNotEmpty(apiKey);
        Validator.isNotEmpty(authority);
        Validator.in(qualifier, "dev", "prod");
        this.context = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.repository.saveSDKInfo(apiKey, qualifier, authority);
        this.parserService = ParserService.getInstance((Context)context);
        this.alarmManager = VisualAlarmManager.getInstance(context);
        this.service = new AnalysisServiceImpl(context, qualifier);
    }

    @Override
    public void startVisual(final @Nullable Activity activity, @NonNull String uid, final @NonNull String path, @NonNull String adId, @NonNull Constants.Gender gender, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.isNotEmpty(uid);
        Validator.notNull(resultListener);
        Validator.notNull(path);
        this.repository.signUp(uid, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                try {
                    if (signUpResult == 0 || signUpResult == 3) {
                        AnswerManager.onKeyMetric(new LogRequest("startVisual"));
                        if (activity == null) {
                            VisualWebActivity.startActivity(VisualServiceImpl.this.context, path);
                        } else {
                            VisualWebActivity.startActivity(activity, path);
                        }
                    }
                }
                catch (AuthException e) {
                    signUpResult = 1;
                    msg = e.toString();
                }
                finally {
                    resultListener.onResult(signUpResult, msg);
                }
            }
        });
    }

    @Override
    public void setVisualCallback(VisualCallback callback) {
        this.repository.setVisualCallback(callback);
    }

    @Override
    public void signOut(Callback<Boolean> callback) {
        this.repository.signOut(new Callback<Boolean>(){

            @Override
            public void onDataLoaded(Boolean value) {
                VisualServiceImpl.this.alarmManager.setAlarms();
            }
        });
    }

    @Override
    public void settingNotification(int smallIcon, @NonNull String channel, int color2) throws ParameterException {
        Validator.notZero(smallIcon);
        Validator.notNull(channel);
        this.repository.settingNotification(smallIcon, channel, color2);
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.isActiveTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    @Override
    public void setReportAlarm(Constants.ReportAlarmType type, boolean isActive) {
        this.repository.setActiveNoti(type.name().toLowerCase(), isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveReportAlarm(Constants.ReportAlarmType type) {
        return this.repository.isActiveNoti(type.name().toLowerCase());
    }

    @Override
    public void setReportTest(Constants.ReportAlarmType type, int second) {
        this.alarmManager.setReportTest(type.name().toLowerCase(), second);
    }

    @Override
    public void setLogger(boolean isActive) {
        if (!this.isActive() || this.parserService != null) {
            // empty if block
        }
    }

    @Override
    public void initSDK() {
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setNotiAll(false);
            this.alarmManager.setAlarms();
        }
    }

    @Override
    public boolean isJoined() {
        return this.repository.isJoined();
    }

    @Override
    public void getVisualSummary(final Callback<VisualSummary> callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                if (!VisualServiceImpl.this.repository.isJoined()) {
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(null);
                        }
                    });
                } else {
                    VisualSummary visualSummary;
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, true, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = VisualServiceImpl.this.repository.loadAnalysisTransactions(request);
                    ArrayList<Analysis> monthly = VisualServiceImpl.this.service.loadAnalysisList(transactions, VisualServiceImpl.this.repository.getStartDay());
                    double sum = VisualServiceImpl.this.getCurrentMonthSum(year, month);
                    if (monthly.isEmpty()) {
                        visualSummary = new VisualSummary(sum, String.format("\uc774\ubc88 \ub2ec \uc9c0\ucd9c\uc740 %1$s \uc785\ub2c8\ub2e4.", AnalysisHelper.getLv0Currency(sum)));
                    } else {
                        Collections.shuffle(monthly);
                        Analysis analysis = monthly.get(0);
                        visualSummary = new VisualSummary(sum, analysis.getlContent());
                    }
                    VisualServiceImpl.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onDataLoaded(visualSummary);
                        }
                    });
                }
            }
        });
    }

    private double getCurrentMonthSum(int year, int month) {
        TransactionRequest currentRequest = new TransactionRequest(year, month, 0, true, "");
        currentRequest.setDwType(Constants.DWType.WITHDRAW.ordinal());
        currentRequest.setExceptType(0);
        ArrayList<Transaction> currentMonthTransactions = this.repository.loadAnalysisTransactions(currentRequest);
        return Utils.sumBy(currentMonthTransactions);
    }

    @Override
    public void setAppNoti(boolean isActive) {
        this.repository.setAppNoti(isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveAppNoti() {
        return this.repository.isAppNoti();
    }

    private boolean isActive() {
        return this.context != null;
    }
}

