/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.Switch;
import android.widget.Toast;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.VisualSummary;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.ui.OnResultListener;

public class MainActivity
extends Activity {
    public static final String API_KEY = "GiAZLGhzbD2tIekv3uMHU5pf3tVR24z34ft1cBgy";
    private VisualService visualService;
    private String visualPath = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main_test);
        try {
            this.visualService = new VisualServiceImpl((Context)this, API_KEY, "dev", "com.tenqube.visual_third");
            this.visualService.setLogger(true);
            Switch popup = (Switch)this.findViewById(R.id.popup);
            popup.setChecked(this.visualService.isActiveTranPopup());
            popup.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setTranPopup(isChecked);
                }
            });
            Switch daily = (Switch)this.findViewById(R.id.daily);
            daily.setChecked(this.visualService.isActiveReportAlarm(Constants.ReportAlarmType.DAILY));
            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setReportAlarm(Constants.ReportAlarmType.DAILY, isChecked);
                }
            });
            Switch weekly = (Switch)this.findViewById(R.id.weekly);
            weekly.setChecked(this.visualService.isActiveReportAlarm(Constants.ReportAlarmType.WEEKLY));
            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setReportAlarm(Constants.ReportAlarmType.WEEKLY, isChecked);
                }
            });
            Switch monthly = (Switch)this.findViewById(R.id.monthly);
            monthly.setChecked(this.visualService.isActiveReportAlarm(Constants.ReportAlarmType.MONTHLY));
            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setReportAlarm(Constants.ReportAlarmType.MONTHLY, isChecked);
                }
            });
            IntentFilter filter = new IntentFilter();
            filter.addAction("tenqube.intent.action.ACTION_TRAN_POPUP");
            this.findViewById(R.id.lv0).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MainActivity.this.visualService.getVisualSummary(new Callback<VisualSummary>(){

                        @Override
                        public void onDataLoaded(VisualSummary value) {
                            Toast.makeText((Context)MainActivity.this.getApplicationContext(), (CharSequence)value.toString(), (int)1).show();
                        }
                    });
                }
            });
            this.findViewById(R.id.web).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MainActivity.this.startVisual();
                }
            });
            this.visualPath = this.getVisualPath();
            if (!TextUtils.isEmpty((CharSequence)this.visualPath)) {
                this.startVisual();
            }
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    private void startVisual() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_SMS") != 0) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.READ_SMS")) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_SMS", "android.permission.RECEIVE_SMS"}, (int)0);
            }
        } else {
            try {
                this.visualService.startVisual(this, ":userUniqueId", this.visualPath, "adId", Constants.Gender.FEMALE, new OnResultListener(){

                    @Override
                    public void onResult(int signUpResult, String msg) {
                        Toast.makeText((Context)MainActivity.this.getApplicationContext(), (CharSequence)("result:" + signUpResult + "msg" + msg), (int)1).show();
                    }
                });
            }
            catch (ParameterException e) {
                e.printStackTrace();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 0: {
                if (grantResults.length <= 0 || grantResults[0] != 0) break;
                this.startVisual();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            default: 
        }
    }

    private String getVisualPath() {
        Intent intent = this.getIntent();
        if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
            String path = intent.getStringExtra("ARG_PATH");
            intent.removeExtra("ARG_PATH");
            return path;
        }
        return "";
    }
}

