/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.model.js.AdRequest;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;

public class AdManager {
    public static final String TAG = AdManager.class.getSimpleName();
    public static final String UNIT_ID = "c-app-pub-1003660361092577/9667135403";
    public static final String AD_ID = "ca-app-pub-1003660361092577~4035782192";
    private static AdManager mInstance = null;
    private VisualRepository repository;
    private Context mContext;
    private boolean isInitCompleted = false;
    public AdRequest adRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdManager getInstance(Context ctx) {
        Class<AdManager> clazz = AdManager.class;
        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private AdManager(Context context) {
        this.mContext = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
                AdManager.this.isInitCompleted = true;
            }
        });
    }

    public void loadAd(AdRequest adRequest, @NonNull OnAdLoadedListener listener) {
        if (this.isInitCompleted) {
            this.adRequest = adRequest;
            this.loadAdmob(adRequest.unitId, listener);
        } else {
            listener.onAdLoaded(null);
        }
    }

    private View populateUnifiedAdView(UnifiedNativeAd nativeAd, UnifiedNativeAdView adView) {
        String linkToBgColor;
        String linkToColor;
        String titleColor;
        String bgColor;
        if (this.adRequest.container != null) {
            bgColor = this.adRequest.container.bgColor;
            titleColor = this.adRequest.container.textColor;
        } else {
            bgColor = "#f0fbff";
            titleColor = "#000000";
        }
        if (this.adRequest.button != null) {
            linkToColor = this.adRequest.button.textColor;
            linkToBgColor = this.adRequest.button.bgColor;
        } else {
            linkToColor = "#ffffff";
            linkToBgColor = "#3684ff";
        }
        this.setBgColor((View)adView, bgColor);
        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
        adView.setBodyView(adView.findViewById(R.id.msg));
        adView.setCallToActionView(adView.findViewById(R.id.link_text));
        if (TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)nativeAd.getCallToAction())) {
            return null;
        }
        ((TextView)adView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
        this.setTextColor((TextView)adView.getHeadlineView(), titleColor);
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(4);
        } else {
            adView.getBodyView().setVisibility(0);
            ((TextView)adView.getBodyView()).setText((CharSequence)nativeAd.getBody());
        }
        adView.getCallToActionView().setVisibility(0);
        ((TextView)adView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
        this.setTextColor((TextView)adView.getCallToActionView(), linkToColor);
        this.setBgColor(adView.findViewById(R.id.linkto), linkToBgColor);
        if (nativeAd.getIcon() == null || nativeAd.getIcon().getDrawable() == null) {
            adView.getIconView().setVisibility(8);
            adView.findViewById(R.id.icon_image_container).setVisibility(8);
        } else {
            ((ImageView)adView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(0);
        }
        adView.setNativeAd(nativeAd);
        return adView;
    }

    void loadAdmob(String unitId, final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(this.mContext, unitId);
        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                UnifiedNativeAdView adView = (UnifiedNativeAdView)LayoutInflater.from((Context)AdManager.this.mContext).inflate(R.layout.visual_unified_admob_view, null);
                View view = AdManager.this.populateUnifiedAdView(unifiedNativeAd, adView);
                if (listener != null && view != null) {
                    listener.onAdLoaded(view);
                }
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                if (listener != null) {
                    listener.onAdLoaded(null);
                }
            }
        }).build();
        com.google.android.gms.ads.AdRequest nativeAdRequest = new AdRequest.Builder().build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void goIntent(Advertisement ad) {
        try {
            if ("app".equals(ad.getLinkToType())) {
                VisualWebActivity.startActivity(this.mContext, "");
            } else if ("market".equals(ad.getLinkToType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket(this.mContext, ad.getLinkTo());
            } else if ("web".equals(ad.getLinkToType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)ad.getLinkTo()));
                this.mContext.startActivity(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable2 = (GradientDrawable)view.getBackground();
                drawable2.setColor(Color.parseColor((String)bgColor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if (!TextUtils.isEmpty((CharSequence)textColor)) {
                view.setTextColor(Color.parseColor((String)textColor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

