/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.search;

import android.text.TextUtils;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.SecretKeyManager;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SearchHeaderInterceptor
implements Interceptor {
    public static final String AUTHORIZATION = "Authorization";
    public static final String X_API_KEY = "x-api-key";
    private final PrefManager prefManager;
    private final SecretKeyManager secretKeyManager;

    public SearchHeaderInterceptor(PrefManager prefManager, SecretKeyManager secretKeyManager) {
        this.prefManager = prefManager;
        this.secretKeyManager = secretKeyManager;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String apiKey = this.prefManager.loadStringValue("TENQUBE_VISUAL_SEARCH_API_KEY", "");
        String token = this.secretKeyManager.getKey("TENQUBE_VISUAL_ACCESS_TOKEN");
        if (TextUtils.isEmpty((CharSequence)apiKey) || TextUtils.isEmpty((CharSequence)token)) {
            throw new IOException("apikey is empty");
        }
        Request.Builder builder = chain.request().newBuilder().addHeader(X_API_KEY, apiKey).addHeader(AUTHORIZATION, token);
        return chain.proceed(builder.build());
    }
}

