package com.tenqube.visual_third.manager;

import android.text.TextUtils;

import com.tenqube.visual_third.BuildConfig;
import com.tenqube.visual_third.util.Utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignatureManager {

    private static SignatureManager mInstance;


    public static SignatureManager getInstance(){
        synchronized (SignatureManager.class) {
            if(mInstance == null){
                mInstance = new SignatureManager();
            }

        }
        return mInstance;
    }

    private SignatureManager() {


    }

    public boolean isValid(int clientVersion, String tenqubeKey, int serverVersion, String rule, String signature) {

        if(TextUtils.isEmpty(signature)) {
           return false;
        }

        String value = clientVersion +
                BuildConfig.SERVICE +
                tenqubeKey +
                serverVersion +
                rule;

        String encrypt = sha512(value.replace("\\", ""));
        Utils.LOGD("isValid", "encrypt" + encrypt);
        Utils.LOGD("isValid", "signature" + signature);

        Utils.LOGD("isValid", "signature.equals(encrypt)" + signature.equals(encrypt));

        return signature.trim().equalsIgnoreCase(encrypt.trim());
    }

    private static String sha512(String str){
        String sha = "";
        try{

            MessageDigest sh = MessageDigest.getInstance("SHA-512");
            sh.update(str.getBytes());
            byte byteData[] = sh.digest();
            StringBuffer sb = new StringBuffer();
            for(int i = 0 ; i < byteData.length ; i++){
                sb.append(Integer.toString((byteData[i]&0xff) + 0x100, 16).substring(1));
            }
            sha = sb.toString();

        }catch(NoSuchAlgorithmException e){
            sha = null;
        }
        return sha;
    }

}
