package com.tenqube.visual_third.api;

import androidx.annotation.Nullable;

import com.tenqube.visual_third.api.auth.AuthService;

import java.io.IOException;

import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

import static com.tenqube.visual_third.api.HeaderInterceptor.AUTHORIZATION;

public class TokenAuthenticator  implements Authenticator {

    private final AuthService authService;

    public TokenAuthenticator(AuthService authService) {
        this.authService = authService;
    }

    private Request getRequest(Response response) {
        return response.request().newBuilder()
                .header(AUTHORIZATION, authService.getAccessToken())
                .build();
    }

    @Nullable
    @Override
    public Request authenticate(Route route, Response response) throws IOException {

        boolean isSuccess = false;
        try {
            isSuccess = authService.reissueToken();
        } catch (Exception e) {
            throw new IOException(e.toString());
        }

        if(!isSuccess) {
            throw new IOException("reissueToken error");
        }
        return getRequest(response);
    }

}
